/****************************************************************************/
/* FILEBOX                                                                  */
/*--------------------------------------------------------------------------*/
/* File selection box                                                       */
/*--------------------------------------------------------------------------*/
/* Author       : DELPRAT Jean-Pierre                                       */
/* Created on   : 12-Jun-96                                                 */
/****************************************************************************/

#include <dir.h>
#include <direct.h>

#ifdef __JPTUI__

  #include "Const.h"
  #include "Vocab.h"

  #include "Mouse.h"
  #include "Strings.h"

  #include "MsgBox.h"

  #include "TCombBox.h"
  #include "TLabel.h"
  #include "TPushBut.h"
  #include "TWindow.h"

  #include "TFileLB.h"

#else

  #include "JPTui.h"
  #include "JPVocab.h"

#endif

#include "FileBox.h"

/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

/*ͻ*/
/*                                  TYPES                                 */
/*ͼ*/

class TFileDialogEditZone;

/*ͻ*/
/*                             STATIC VARIABLES                           */
/*ͼ*/

static char                    s_file[MAX_PATH]="";
static char                    s_current_dir_mask[MAX_PATH]="";

static char *s_ok_button_caption=NULL;
static char *s_cancel_button_caption=NULL;

static PWindow                 s_window=NULL;
static PLabel                  s_label=NULL;
static PComboBox               s_combo_box=NULL;
static PFileListBox            s_file_list_box=NULL;
static TFileDialogEditZone     *s_edit_zone=NULL;
static PPushButton   	       s_ok_button=NULL;
static PPushButton   	       s_cancel_button=NULL;

static boolean                 s_file_chosen=FALSE;

/*ͻ*/
/*                            CLASS DEFINITIONS                           */
/*ͼ*/

// file mask editing zone

class TFileDialogEditZone:public TEditZone
{
  public:
		    TFileDialogEditZone(const char *default_mask);
		   ~TFileDialogEditZone();
	    void    m_refresh_file_list_from_string();

};

TFileDialogEditZone::TFileDialogEditZone(const char *default_mask)
		    :TEditZone(s_window,
			       9,15,
			       -7,0,
			       GetString(VOC_FILENAME_CAPTION),
			       36,
			       MAX_PATH,
			       default_mask)
{
}

TFileDialogEditZone::~TFileDialogEditZone()
{
}

static void FileChosenCall(PObject /*sender*/, const char */*arg*/);

void TFileDialogEditZone::m_refresh_file_list_from_string()
{
  // The file mask in the editing zone is changed
  // when the list of files is refreshed

  switch (s_file_list_box->m_refresh_file_list(m_get_string()))
    {
      case FLB_REFRESH_OK_FILE   : FileChosenCall(s_file_list_box,"");
				   break;

      default                    : m_set_focus();
				   break;
    }
}

/*ͻ*/
/*                                 FUNCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* CancelButtonPressedCall                                                  */
/*--------------------------------------------------------------------------*/
/* Function called when the user presses the "cancel" button of the dialog  */
/****************************************************************************/

static void CancelButtonPressedCall(PObject /*sender*/, const char */*arg*/)
{
  JPStop();
}

/****************************************************************************/
/* OkButtonPressedCall                                                      */
/*--------------------------------------------------------------------------*/
/* Function called when the user presses the "ok" button of the dialog      */
/****************************************************************************/

static void OKButtonPressedCall(PObject /*sender*/, const char */*arg*/)
{
  PObject object=s_window->m_get_previous_focused_object();
  TFLBError error_code;

  if (object!=NULL)
    {
      if (object->m_get_number()==s_file_list_box->m_get_number())
	{
	  error_code = s_file_list_box->m_refresh_file_list_from_item(s_file_list_box->m_get_selected_item_index());

	  if (error_code == FLB_REFRESH_OK_FILE)
	    FileChosenCall(s_file_list_box,"");

	  s_file_list_box->m_set_focus();
	  return;
	}
    }

  s_edit_zone->m_refresh_file_list_from_string();
}

/****************************************************************************/
/* FileChosenCall                                                           */
/*--------------------------------------------------------------------------*/
/* Function called when a file (or directory) has been chosen in the list-  */
/* box which displays file names					    */
/****************************************************************************/

static void FileChosenCall(PObject /*sender*/, const char */*arg*/)
{
  s_file_chosen=TRUE;
  JPStop();
}

/****************************************************************************/
/* ChangeOkButtonCaptionCall				                    */
/*--------------------------------------------------------------------------*/
/* Function called when the caption of the ok button may have to be changed */
/****************************************************************************/

static void ChangeOkButtonCaptionCall(PObject sender, const char */*arg*/)
{
  static boolean s_open_dir_caption = FALSE;
  int   selected_item_index;
  char *item;

  boolean open_dir_caption = FALSE;

  PFileListBox list_box = (PFileListBox)sender;

  if (list_box->m_has_focus())
    {
      selected_item_index = list_box->m_get_selected_item_index();

      if (selected_item_index != 0)
	{
	  item=list_box->m_get_item(selected_item_index);
	  if ((item[0]==FLB_PARENT_DIR_CHAR) || (item[0]==FLB_SUB_DIR_CHAR))
	    open_dir_caption=TRUE;
	}
    }

  if (open_dir_caption != s_open_dir_caption)
    {
      s_ok_button->m_set_caption( open_dir_caption?
				  GetString(VOC_OPEN_DIRECTORY_CAPTION):
				  s_ok_button_caption);

      s_open_dir_caption = open_dir_caption;
    }
}

/****************************************************************************/
/* DirChangedCall                                                           */
/*--------------------------------------------------------------------------*/
/* Function called when a new drive or directory has been chosen in the     */
/* combo box which displays available drives and the parent directories     */
/****************************************************************************/

static void FileRefreshDoneCall(PObject sender, const char */*arg*/);

static void DirChangedCall(PObject /*sender*/, const char */*arg*/)
{
  int first;
  int level;
  register int i;

  char dir_mask[MAX_PATH];
  char *item;

  PSimpleList list=s_combo_box->m_get_list();

  int  selected_item_index=list->m_get_selected_item_index();

  if (selected_item_index==0)
    return;

  item=list->m_get_item(selected_item_index);

  // Drive

  if (item[0]!=' ')
    first=selected_item_index;

  // Sub-directories

  else
    {
      level=2;
      while (item[level]=='\x7')
	level++;
      first=selected_item_index-level+2;
    }

  // New mask of files

  strcpy(dir_mask,list->m_get_item(first));
  level=3;
  for (i=first+1;i<=selected_item_index;i++)
    {
      strcat(dir_mask,(list->m_get_item(i))+level);
      strcat(dir_mask,"\\");
      level++;
    }

  switch (s_file_list_box->m_refresh_file_list(dir_mask))
    {
      case FLB_INVALID_DRIVE    :
      case FLB_NO_DISK_IN_DRIVE	:
      case FLB_INVALID_DIR      :
      case FLB_INVALID_FILE     : FileRefreshDoneCall(s_file_list_box,"");
                                  break;
      default                   : break;
    }
}

/****************************************************************************/
/* FileRefreshDoneCall                                                      */
/*--------------------------------------------------------------------------*/
/* Function called when the list of files is refreshed in                   */
/* the list-box which displays file names				    */
/****************************************************************************/

static void FileRefreshDoneCall(PObject sender, const char */*arg*/)
{
  int item_to_select=0;
  int level;
  char old_char=0;
  char *item;
  char new_item[MAX_PATH];
  char *ptr1,*ptr2;

  char *dir=((TFileListBox *)sender)->m_get_current_dir();
  int length=strlen(dir);
  int label_width=s_label->m_get_width();

  PSimpleList list=s_combo_box->m_get_list();

  int nb_items;
  register int i;
  char *new_text;

  int insert_index=0;

  // Disables the combo-box callback

  s_combo_box->m_set_string_validated_callback(NULL,"");

  // Displays the current directory

  new_text=new char [(2*label_width)+1];

  strncpy(new_text,dir,label_width);
  if (length>label_width)
    {
      new_text[label_width]='\n';
      strncpy(new_text+label_width+1,dir+label_width,label_width);
      new_text[(2*label_width)+1]=0;
    }
  else
    new_text[label_width]=0;

  s_label->m_set_text(new_text);
  delete []new_text;

  // Updates the combo-box

  i=1;
  nb_items=list->m_get_nb_items();
  while (i<=nb_items)
    {
      item=list->m_get_item(i);
      if (item[1]!=':')
	{
	  list->m_delete_item(i);
	  i--;
	  nb_items--;
	}
      else
	{
	  if (item[0]==dir[0])
	    insert_index=i;
	}
      i++;
    }


  if (insert_index!=0)
    {
      strcpy(new_item,"  ");
      level=strlen(new_item);
      ptr1=strchr(dir,'\\');
      while (ptr1!=NULL)
	{
	  ptr1++;
	  if ((*ptr1)!=0)
	    {
	      ptr2=strchr(ptr1,'\\');
	      if (ptr2!=NULL)
		{
		  old_char=(*ptr2);
		  (*ptr2)=0;
		}
	      new_item[level]='\x7';
	      level++;
	      strcpy(new_item+level,ptr1);
	      if (ptr2!=NULL)
		(*ptr2)=old_char;
	      insert_index++;
	      list->m_insert_item(insert_index,new_item);
	      nb_items++;
	      ptr1=ptr2;
	    }
	  else
	    ptr1=NULL;

	  item_to_select=insert_index;
	}
    }

  if (item_to_select!=0)
    list->m_set_selected_item_index(item_to_select);

  // Updates the file mask editing zone

  s_edit_zone->m_set_string(s_file_list_box->m_get_current_mask());

  // Enables again the combo-box callback

  s_combo_box->m_set_string_validated_callback(DirChangedCall,"");
}

/****************************************************************************/
/* FillComboBoxWithDrives                                                   */
/*--------------------------------------------------------------------------*/
/* Insert available drives in the combo-box				    */
/****************************************************************************/

static void FillComboBoxWithDrives()
{
  char *item;
  int disk;
  PSimpleList list=s_combo_box->m_get_list();

    // Lecture des disques

  item="X:\\";

  for (disk = 0;disk < 26;++disk)
    {
      if (DriveExists(disk))
	{
	  item[0]=disk+'A';
	  list->m_add_item(item);
	}
    }
}

/****************************************************************************/
/* File selection box                                                       */
/*--------------------------------------------------------------------------*/
/* Allows the users to select a existing file or enter a new filename       */
/****************************************************************************/

char *FileSelectionBox(const char *title, const char *mask,
		       const char *ok_button_caption,
		       const char *cancel_button_caption)
{
  const char *caption;
  char full_path_mask[MAX_PATH];

  TMousePointer pointer;

  // Determines the full path mask

  FullPath(full_path_mask,mask);

  // Saves the captions of buttons

  caption= ((ok_button_caption[0]==0)?
	   GetString(VOC_OK_CAPTION):
	   ok_button_caption);

  s_ok_button_caption = new char [strlen(caption)+1];
  strcpy(s_ok_button_caption,caption);

  caption= ((cancel_button_caption[0]==0)?
	   GetString(VOC_CANCEL_CAPTION):
	   cancel_button_caption);
  s_cancel_button_caption = new char [strlen(caption)+1];
  strcpy(s_cancel_button_caption,caption);

  // Allocates the elements of the dialog box

  s_window=new TWindow(DIALOG3,
		     10,4,61,20,
		     title,
		     NO_INFO_BAR,
		     MODAL,
		     MOVABLE);



  s_combo_box=new TComboBox(s_window,
			  15,2,
			  -13,0,GetString(VOC_SEARCH_CAPTION),
			  40,MAX_PATH,
			  "",
			  8,
			  NULL,
			  STRING_MUST_BE_IN_LIST,
			  NOT_SORTED);

  s_file_list_box=new TFileListBox(s_window,
				 2,4,
				 57,10,
				 s_current_dir_mask);

  s_edit_zone=new TFileDialogEditZone("");

  s_label=new TLabel(s_window,
		   2,17,
		   45,2);

  s_ok_button=new TPushButton(s_window,
			    48,15,
			    11,
			    s_ok_button_caption,
			    PB_DEFAULT);

  s_cancel_button=new TPushButton(s_window,
			       48,17,
			       11,
			       s_cancel_button_caption,
			       PB_CANCEL);

  // Initializes the combo-box

  FillComboBoxWithDrives();

  // Defines the callbacks

  s_cancel_button->m_set_pressed_callback(CancelButtonPressedCall, "");
  s_ok_button->m_set_pressed_callback(OKButtonPressedCall, "");
  s_file_list_box->m_set_refresh_done_callback(FileRefreshDoneCall,"");
  s_file_list_box->m_set_file_chosen_callback(FileChosenCall,"");
  s_file_list_box->m_set_focus_taken_callback(ChangeOkButtonCaptionCall,"");
  s_file_list_box->m_set_focus_lost_callback(ChangeOkButtonCaptionCall,"");
  s_file_list_box->m_set_selected_item_changed_callback(ChangeOkButtonCaptionCall,"");
  s_edit_zone->m_set_focus();

  s_file_list_box->m_refresh_file_list(full_path_mask);

  // Defines the mouse pointer (in case it would have been changed)

  pointer=GetMousePointer();
  SetMousePointer(MP_ARROW);

  // Opens and runs the dialog box

  s_window->m_open();

  s_file_chosen=FALSE;
  JPRunDialog();

  // Has the user pressed the "cancel" button...

  if (!s_file_chosen)
    s_file[0]=0;

  // ... or chosen a filename

  else
    {
      strcpy(s_file,s_file_list_box->m_get_current_dir());
      if (EndOfString(s_file)!='\\')
	strcat(s_file,"\\");
      strcat(s_file,s_file_list_box->m_get_current_mask());

      // The current directory and filename mask are saved into memory.
      // They will be used as default parameters when this dialog will be
      // open again.

      strcpy(s_current_dir_mask,s_file_list_box->m_get_current_dir());
      if (EndOfString(s_current_dir_mask)!='\\')
	strcat(s_current_dir_mask,"\\");
      strcat(s_current_dir_mask,s_file_list_box->m_get_current_mask());
    }

  // Closes the dialog box

  s_window->m_close();
  JPRefresh();

  // Restores the mouse pointer

  SetMousePointer(pointer);

  // Destructs dynamically-allocated objects

  delete s_cancel_button;
  delete s_ok_button;
  delete s_label;
  delete s_edit_zone;
  delete s_file_list_box;
  delete s_combo_box;
  delete s_window;

  delete []s_ok_button_caption;
  delete []s_cancel_button_caption;

  // Returns the chosen file ("" if none)

  return(s_file);
}
