/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** PLVGA.CC: This file is part of the BETATRON library and can be used
 **           and/or distributed only under the terms of the GNU Library
 **           General Public License. See doc/readme.1st for details.
 */



#include <stdlib.h>
#include <pc.h>
#include <dpmi.h>
#include <string.h>

// pl_setstartadr, pl_retrace, pl_sethorpel
// pl_rawto4planes,pl_getRGBcolor,pl_isvga,pl_setpal,pl_setvideomode,pl_line
// pl_tiletoraw2, pl_raw2rle

void pl_setstartadr(long adrs)
{
asm("  \
       movw %0,%%ebx	    \n \
       movw $0x03d4,%%dx    \n \
       movb $0x0c,%%al	    \n \
       movb %%bh,%%ah	    \n \
       outw %%ax,%%dx	    \n \
       movb $0x0d,%%al	    \n \
       movb %%bl,%%ah	    \n \
       outw %%ax,%%dx	    \n \
     ": : "m" (adrs): "ebx","eax","edx");
}


void pl_retrace()
{
 asm(" pushw %dx;pushw %ax; pushfl \n   \
   wait1:		 \n   \
     movw $0x3da,%dx	 \n   \
	  inb %dx,%al	      \n   \
	  testb $8,%al	      \n   \
	  jnz wait1	      \n   \
   wait2:		 \n   \
	  inb %dx,%al	      \n   \
	  testb $8,%al	      \n   \
	  jz wait2	      \n   \
	  popfl; popw %ax;popw %dx   ");
}


void pl_sethorpel(unsigned char value)
{
asm("   \
	    movw $0x3da,%%dx   \n \
	    inb %%dx,%%al      \n \
	    movw $0x3c0,%%dx   \n \
	    movb $0x33,%%al   \n \
	    outb %%al,%%dx     \n \
	    movb %0,%%al       \n \
	    outb %%al,%%dx     \n \
       " : : "m" (value): "edx" ,"eax");
}



char *pl_tilerawto4planes(char *intile,char * &outtile)
{
  register char *pin;
  register char *pout;
  register short i;

  if (!outtile) if ( !(outtile=(char *)malloc(256)) ) return NULL;

  pout=outtile;
  pin=intile;

  for (i=0; i<64; i++,pout++)
  {
    *pout	= *pin++;
    *(pout+64)	= *pin++;
    *(pout+128) = *pin++;
    *(pout+192) = *pin++;
  }

  return outtile;
}



char *pl_tile4planes2raw(char *intile,char * &outtile)
{
  register char *t,*ot;
  register short i;

  if (!outtile) if ( !(outtile=(char *)malloc(256)) ) return NULL;

  t=intile;  ot=outtile;

  for (i=0;i<64;i++,t++)
  {
    *ot++   =	*t;
    *ot++   =	*(t+64);
    *ot++   =	*(t+128);
    *ot++   =	*(t+192);
  }
  return outtile;
}


char *pl_4planes2raw(char *map,unsigned short len,unsigned short hei)
{
 char *out;
 unsigned long plen;
 register char *pout,*pout2;
 register char *pin;
 register unsigned short i,j;

 if ( !(out=(char *)malloc(len*hei)) ) return NULL; // apotixia desmeusis mnimis

 plen=len >> 2; if (len & 3) plen++;

 pin=map;
 pout=out;
 for (j=0;j<hei;j++,pout+=len)
 {
   pout2=pout;
   for (i=0;i<plen;i++,pin++,pout2+=4) *pout2=*pin;
 }

   // if (len < 1) return out; // it cant be

 plen = (len-1) >> 2; if ( (len-1) & 3) plen++;

 pout=out+1;
 for (j=0;j<hei;j++,pout+=len)
 {
   pout2=pout;
   for (i=0;i<plen;i++,pin++,pout2+=4) *pout2=*pin;
 }

 if (len < 2) return out;

 plen = (len-2) >> 2; if ( (len-2) & 3) plen++;

 pout=out+2;
 for (j=0;j<hei;j++,pout+=len)
 {
   pout2=pout;
   for (i=0;i<plen;i++,pin++,pout2+=4) *pout2=*pin;
 }


 if (len < 3) return out;

 plen = (len-3) >> 2; if ( (len-3) & 3) plen++;

 pout=out+3;
 for (j=0;j<hei;j++,pout+=len)
 {
   pout2=pout;
   for (i=0;i<plen;i++,pin++,pout2+=4) *pout2=*pin;
 }


 return out;
}





char *pl_rawto4planes(char *inmap,unsigned short len,unsigned short hei)
{
 register unsigned short i,j;
 unsigned long plane1,plane2,plane3;
 unsigned short l;
 char *outmap;
 register char *pin,*pin2;
 register char *pout;

 if ( !(outmap=(char *)malloc(len*hei)) ) return NULL; // apotixia desmeusis mnimis

 l=len>>2;
 if (len & 03) l++;
 plane1= l*hei;  // pou arxizei to deutero bitplane
 if (len<1) plane2=plane1;
 else
  {
   l=(len-1)>>2;
   if ((len-1) & 03) l++;
   plane2=plane1+  l*hei;
  }

 if (len<2) plane3=plane2;
 else
  {
   l=(len-2)>>2;
   if ((len-2) & 03) l++;
   plane3=plane2+ l*hei;
  }

 pin=inmap;
 pout=outmap;
 for (j=0;j<hei;j++,pin+=len)
 {
  pin2=pin+0;
  for (i=0;i<len;i+=4,pin2+=4,pout++)
  *pout=*pin2;
 }


 pin=inmap;
 pout=outmap+plane1;
 for (j=0;j<hei;j++,pin+=len)
 {
  pin2=pin+1;
  for (i=1;i<len;i+=4,pin2+=4,pout++)
  *pout=*pin2;
 }


 pin=inmap;
 pout=outmap+plane2;
 for (j=0;j<hei;j++,pin+=len)
 {
  pin2=pin+2;
  for (i=2;i<len;i+=4,pin2+=4,pout++)
  *pout=*pin2;
 }


 pin=inmap;
 pout=outmap+plane3;
 for (j=0;j<hei;j++,pin+=len)
 {
  pin2=pin+3;
  for (i=3;i<len;i+=4,pin2+=4,pout++)
  *pout=*pin2;
 }

 return outmap;
}


// converts an rle to raw format

char *pl_rle2raw(char *rle,unsigned short l,unsigned short h)
{
 char *buf;
 unsigned short i,j,k;
 char *p,*p2;
 unsigned short packetsno;
 char ch;
 char *b;

 p=rle+8; // skip the length, height and total size of rle

 if (!(buf=(char *)malloc(l*h)) ) return NULL;

 p2=p+2;    // kane skip to mikos dedomenon tis grammis
 b=buf;
 for (i=0;i<h;i++, p+=(*((short *)p)), p2=p+2 )
 {
    packetsno=*((short *)p2); p2+=2;
    for (j=0;j<packetsno;j++)
    {
      ch=(*p2); // paket type
      p2++;
      // copy count
      if (! (ch & 128) )
      {
       for (k=0;k<ch & 127;k++,b++,p2++) *b=*p2;
       continue;
      }

      // skip count
       for (k=0;k<(ch & 127);k++,b++) *b=0;

    }
  }

  return buf;
}



char *pl_raw2rle(char *raw,unsigned short l,unsigned short h)
{
 char **buf;	   // pinakas deikton se chars
 unsigned short i,j,k;
 char *tmpbuf;
 unsigned char ch;
 char *p;
 char *p2;
 int d;
 char samebytes;
 short tmpcount=0;
 short packetsno;
 unsigned long totalsize=0;
 char *final;

 if (! (buf=(char **) malloc(h*sizeof(char *))) ) return NULL;
 if (! (tmpbuf= (char *)malloc(l*4)) ) {free(buf); return NULL;}

 p=raw;
 for (i=0;i<h;i++,raw+=l,p=raw)
 {
  packetsno=0;
  tmpcount=0;

  for (j=0;j<l;)
  {

// ---------------- vres an iparxei paketo skipcount
  // vres posa sinexomena midenika iparxoun
   for ( d=j; (*p)==0; j++,p++) if ( (j>=l) || (j-d>=127) ) break;

   // an iparxoun midenika bytes prepei na ftiaksoume paketo
   if (j-d)
   {
    ch= (1 << 7)+ j-d;	 // 01.(j-d)
    tmpbuf[tmpcount]=ch; packetsno++;tmpcount++;
   }


// ---------------- vres an iparxei paketo copycount
   if (j<l)
   {
    for (d=j,ch=(*p);; p++,j++)
    {
     if ( (j>=l) ||(j-d>=127)) break;
     if ( (*p)==0) break;
    }

    if (j-d)
    {
      tmpbuf[tmpcount++]=j-d; // paketo copy count
      p2=p-(j-d);
      for (k=0;k<j-d;k++,p2++)
	 tmpbuf[tmpcount++]= (*p2);
      packetsno++;
    }
   }
  }  // for j

  //-----------------------------------------------------------------


  if ( !(buf[i]=(char *) malloc(tmpcount+2*sizeof(short))) )
  {
    free(tmpbuf); for (k=0;k<i;k++) free(buf[k]); free(buf);
    return NULL;
  }

  *((short *)buf[i])=tmpcount+4;
  *((short *)(buf[i]+2))=packetsno;
  memcpy(buf[i]+4,tmpbuf,tmpcount);
  totalsize+=tmpcount+4;

 }  // for i	  pigaine stin pomeni grammi tou rle

//-----------------------------------------------------------------------
 free(tmpbuf);
 if ( ! (final=(char *)malloc(totalsize+8) ) )
 {
    for (k=0;k<h;k++) free(buf[k]); free(buf);
    return NULL;
 }

 *((short *)final)=l;
 *((short *)(final+2))=h;
 *((long *)(final+4))=totalsize+8;


 p=(final+8);
 for (k=0;k<h;k++)
 {
  memmove(p,buf[k], *((short *)buf[k]));
  p+=(*((short *)buf[k]));
 }

 for (k=0;k<h;k++) free(buf[k]); free(buf);
 return final;

}






void pl_getRGBcolor(unsigned char i,char &R,char &G,char &B)
{
 outportb(0x3c7,i);  //pelread
 R=inportb(0x3c9);   //peldata
 G=inportb(0x3c9);
 B=inportb(0x3c9);
}


char pl_isvga()
{
  __dpmi_regs r;

  r.x.ax=0x1a00;
  __dpmi_int(0x10,&r);
  return (r.h.al==0x1a);
}


void  pl_setpal(char *PPalette)
{
  asm(" movl  %0, %%esi             \n \
	movw $0x3c8,%%dx	    \n \
	outb %%al,%%dx		    \n \
	xor  %%al,%%al		    \n \
	outb %%al,%%dx		    \n \
	incw %%dx		    \n \
	movl $768,%%ecx 	     \n \
	cld			    \n \
	rep			    \n \
	outsb  ": : "m" (PPalette): "%eax","%esi","%edx","%ecx","cc");
}


void pl_setvideomode(unsigned char mode)
{
 __dpmi_regs r;

  r.h.ah=0;
  r.h.al=mode;
  __dpmi_int(0x10,&r);
}


void pl_line(short x1,short y1,short x2, short y2,
	  char	color ,char *buf,unsigned short buflen)
{


short i, deltax, deltay,
      x, xinc1, xinc2,
      y, yinc1, yinc2,
	 dinc2 ;

long screen,d,numpixels;
long screeninc1, screeninc2;
long dinc1;


//  { Calculate deltax and deltay for initialisation }
  deltax = abs(x2 - x1);
  deltay = abs(y2 - y1);

//  { Initialize all vars based on which is the independent variable }
  if (deltax >= deltay)
   {
    //	{ x is independent variable }
      numpixels = deltax + 1;
      d = (deltay<<1) - deltax;
      dinc1 = deltay << 1;
      dinc2 = (deltay - deltax) << 1;
      xinc1 = 1;
      xinc2 = 1;
      yinc1 = 0;
      yinc2 = 1;
    }
  else
    {
     // { y is independent variable }
      numpixels = deltay + 1;
      d = (deltax<<1) - deltay;
      dinc1 = deltax << 1;
      dinc2 = (deltax - deltay) << 1;
      xinc1 = 0;
      xinc2 = 1;
      yinc1 = 1;
      yinc2 = 1;
    };

//  { Make sure x and y move in the right directions }
  if (x1 > x2)
    {
      xinc1 = - xinc1;
      xinc2 = - xinc2;
    };
  if (y1 > y2)
    {
      yinc1 = - yinc1;
      yinc2 = - yinc2;
    };

//  { Start drawing at <x1, y1> }
  x = x1;
  y = y1;

//  { Start drawing at <x1, y1> }
  screen = ((long)y1) * buflen + x1;
  screeninc1 = (long)yinc1 * (long)buflen + xinc1;
  screeninc2 = (long)yinc2 * (long)buflen + xinc2;

//  { Draw the pixels }


  asm (" \n\
       movl %0,%%edi  \n \
       addl %1,%%edi  \n \
       movl %2,%%edx  \n \
       movb %3,%%al   \n \
       movl %4,%%ecx  \n \
       movl %5,%%ebx  \n \
bres1: \n \
       movb  %%al,(%%edi)\n \
       testw %%dx, %%dx  \n \
       jnl bres2	 \n \

       addw %%bx,%%dx	\n \
       addl %6,%%edi	\n \
       jmp bres3	\n \
bres2: \n \
\n \
       addw %7, %%dx	\n \
       addl %8, %%edi	\n \
bres3:			\n \
       decl %%ecx	\n \
       jnz  bres1    \n": : "m" (buf), "m" (screen), "m" (d),"m" (color),
			 "m" (numpixels), "m" (dinc1),"m" (screeninc1),
			 "m" (dinc2), "m" (screeninc2)
			 : "%edi","%edx","%eax","%ebx","%ecx","cc","memory");

// o djgpp exei bug tou eipa na valei to buf ston edi kai to evale
// ston edx
};







