#include <stdio.h>
#include "stone.h"
#include "info.h"

int stone_info_stone (char *filename)
{
  stone_object_rel *rel;
  stone_object_sym *sym;
  stone_object *obj;
  int idx, c;
  
  if ((idx = stone_load (filename)) < 0)
  {
    out ("Error reading '%s'\n", filename);
    return 0;
  }

  obj = &stone_obj [idx];
  out ("Object file '%s'\n", obj->src);
  out ("%d byte%s in data\n", obj->len, obj->len == 1 ? "" : "s");
  out ("%d symbol%s\n", obj->nsym, obj->nsym == 1 ? "" : "s");
  out ("%d relocation%s\n", obj->nrel, obj->nrel == 1 ? "" : "s");
  out ("\n");

  for (sym = obj->sym, c = 0; c < obj->nsym; c ++, sym ++)
  {
    out ("Symbol '%s'\n", sym->name);
    out ("  Offset %d (%Xh)\n", sym->off, sym->off);
    if (sym->type == csst_import)
      out ("  Import\n");
    else if (sym->type == csst_export)
      out ("  Export\n");
    else if (sym->type == csst_unknown)
      out ("  Unknown\n");
    else
      out ("  Unhandled (%d)\n", sym->type);
    out ("\n");
  }

  for (rel = obj->rel, c = 0; c < obj->nrel; c ++, rel ++)
  {
    out ("Relocate %d/%Xh %s %+d/%s%Xh - ", rel->off, rel->off, obj->sym [rel->sym].name, rel->base, rel->base < 0 ? "-" : "+", abs (rel->base));
    switch (rel->type)
    {
      case csr_unknown:   out ("unknown\n");      break;
      case csr_relative:  out ("relative\n");     break;
      case csr_absolute:  out ("absolute\n");     break;
      case csr_relative2: out ("relative (2)\n"); break;
      case csr_absolute2: out ("absolute (2)\n"); break;
      default: out ("unhandled %d\n", rel->type); break;
    }
  }

  return 1;
}
