/*
 * BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 * Copyright (C) 1993-96 by Hartmut Schirmer
 *
 * This library is copyrighted (see above). It might be used and
 * distributed freely as long as all copyright notices are left
 * intact.
 *
 * You may not distribute any changed versions of BCC2GRX without
 * written permission by Hartmut Schirmer.
 *
 * You are permitted to distribute an application linked with BCC2GRX
 * in binary only, provided that the documentation of the program:
 *
 *    a)   informs the user that BCC2GRX is used in the program, AND
 *
 *    b)   provides the user with the necessary information about
 *         how to obtain BCC2GRX. (i.e. ftp site, etc..)
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Contact :                Hartmut Schirmer
 *                          Feldstrasse 118
 *                  D-24105 Kiel
 *                          Germany
 *
 * e-mail : hsc@techfak.uni-kiel.d400.de
 */

#include "bccgrx00.h"

/*
   - Take care : Borland C defines polypoints as int * but
   -             assumes struct pointtype *  .
   -             GRX requires int points[][2] !
   - The good news are : Both definitions are compatible !
*/

void __gr_drawpoly(int numpoints, void *polypoints, int close)
{
  int *pp, x, y, sx, sy, nx, ny, fast;

  _DO_INIT_CHECK;
  LNE.lno_color = COL|WR;
  fast = (__gr_lstyle == SOLID_LINE) && (LNE.lno_width == 1);
  pp = (int *)polypoints;
  while (numpoints > 0) {
    x = sx = *(pp++)+VL;
    y = sy = *(pp++)+VT+PY;
    --numpoints;
    while (numpoints > 0)  {
      nx = *(pp++) + VL;
      ny = *(pp++) + VT + PY;
      if (fast) GrLine( x, y, nx, ny, LNE.lno_color);
	   else GrCustomLine( x, y, nx, ny, &LNE);
      x = nx; y = ny;
      --numpoints;
      if ( x==sx && y==sy)
	break;
    }
    if ( close && (x != sx || y != sy))
      if (fast) GrLine( x, y, sx, sy, LNE.lno_color);
	   else GrCustomLine( x, y, sx, sy, &LNE);
  }
}

