/*
 *    Chipset-specific SVGA video drivers for the Allegro library.
 *
 *    See vdrv.txt for copyright information.
 *
 *    Interface header file, to be included by client programs.
 */


#ifndef VDRV_H 
#define VDRV_H 


#include "allegro.h"


#ifdef __cplusplus
extern "C" {
#endif


/* version number stuff */
#define VDRV_VERSION          1
#define VDRV_SUB_VERSION      0
#define VDRV_VERSION_STR      "1.0"
#define VDRV_DATE_STR         "1998"
#define VDRV_DATE             19981212    /* yyyymmdd */

extern char vdrv_id[];


/* main module init function */
void vdrv_init();


/* driver ID codes */
#define GFX_ATI                  AL_ID('A','T','I',' ')
#define GFX_MACH64               AL_ID('M','A','6','4')
#define GFX_CIRRUS64             AL_ID('C','I','6','4')
#define GFX_CIRRUS54             AL_ID('C','I','5','4')
#define GFX_PARADISE             AL_ID('P','A','R','A')
#define GFX_S3                   AL_ID('S','3',' ',' ')
#define GFX_TRIDENT              AL_ID('T','R','I','D')
#define GFX_ET3000               AL_ID('E','T','3','0')
#define GFX_ET4000               AL_ID('E','T','4','0')
#define GFX_ET6000               AL_ID('E','T','6','0')
#define GFX_VIDEO7               AL_ID('V','I','D','7')


/* driver structure definitions */
extern GFX_DRIVER gfx_ati, gfx_mach64, gfx_cirrus64, gfx_cirrus54,
		  gfx_s3, gfx_trident, gfx_et3000, gfx_et4000, 
		  gfx_et6000, gfx_paradise, gfx_video7;


/* macros for adding our routines to the video driver list */
#define GFX_DRIVER_ATI                                                       \
   {  GFX_ATI,          &gfx_ati,            TRUE   },

#define GFX_DRIVER_MACH64                                                    \
   {  GFX_MACH64,       &gfx_mach64,         TRUE   },

#define GFX_DRIVER_CIRRUS64                                                  \
   {  GFX_CIRRUS64,     &gfx_cirrus64,       FALSE  },

#define GFX_DRIVER_CIRRUS54                                                  \
   {  GFX_CIRRUS54,     &gfx_cirrus54,       TRUE   },

#define GFX_DRIVER_PARADISE                                                  \
   {  GFX_PARADISE,     &gfx_paradise,       TRUE   },

#define GFX_DRIVER_S3                                                        \
   {  GFX_S3,           &gfx_s3,             TRUE   },

#define GFX_DRIVER_TRIDENT                                                   \
   {  GFX_TRIDENT,      &gfx_trident,        TRUE   },

#define GFX_DRIVER_ET3000                                                    \
   {  GFX_ET3000,       &gfx_et3000,         FALSE  },

#define GFX_DRIVER_ET4000                                                    \
   {  GFX_ET4000,       &gfx_et4000,         TRUE   },

#define GFX_DRIVER_ET6000                                                    \
   {  GFX_ET6000,       &gfx_et6000,         TRUE   },

#define GFX_DRIVER_VIDEO7                                                    \
   {  GFX_VIDEO7,       &gfx_video7,         TRUE   },



#ifdef __cplusplus
}
#endif


#endif          /* ifndef VDRV_H */
