/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for drawing on the text screen.

*/
#ifndef s_temo_h
#define s_temo_h

#include "s_defs.h"
#include "s_math.h"

/* TeMo - TextMode functions for djgpp
	by Sven Sandberg

	This file contains some functions for drawing in textmode.*/

/*typedef struct blinkklutt{
	ushort ascii:     8;
	ushort fore:4;
	ushort back:3;
	ushort blink:     1;
}TBLINKKLUTT;
typedef struct backklutt{
	ushort ascii:     8;
	ushort fore:4;
	ushort back:4;
}TBACKKLUTT;*/

//The position in dos-memory where the screen begins.
#define screenstart  (0xb8000)


/* Gets/sets textattributes for future calls to cprintf when you're working
in text mode.
Background and foreground gets and sets the color for text.
Blink turns on/off blinking text (nonzero turns blink on, zero turns blinking
off).
Textattr gets and sets all the three attributes at one time, in the cryptic
format used by the standard functions.
(The inline functions just give the standard functions the same syntax as my
functions.)*/
extern inline void textsetcurrentfore(int _color);
extern inline void textsetcurrentback(int _color);
extern void textsetcurrentblink(int onoff);
extern inline void textsetcurrentattr(int _attr);
extern int  textgetcurrentfore(void);
extern int  textgetcurrentback(void);
extern int  textgetcurrentblink(void);
extern int  textgetcurrentattr(void);


//Sets and gets the dimensions of screen if you are in textmode. Available
//heights are 25, 28, 35, 40, 43 and 50.
extern int getscreenheight(void);
extern int getscreenwidth(void);
extern int setscreenheight(int numrows);


//Draws a rectangle using the specified character.
extern void textoutlinerect(int x,int y,int w,int h,int klutt,int kluttmask);
extern void textfillrect(int x,int y,int w,int h,int klutt,int kluttmask);
extern void texthline(int x,int y,int w,int klutt,int kluttmask);
extern void textvline(int x,int y,int w,int klutt,int kluttmask);


//Draws in the video memory. Does not support clipping.
extern inline void textputchar(int x,int y,int value);
extern int  textgetchar(int x,int y);
extern inline void textputattr(int x,int y,int value);
extern int  textgetattr(int x, int y);
extern inline void textputklutt(int x,int y,int value);
extern int  textgetklutt(int x, int y);
extern void textputblink(int x, int y, int value);
extern int  textgetblink(int x, int y);
extern void textputback16(int x, int y, int value);
extern int  textgetback16(int x, int y);
extern void textputbackblink(int x, int y, int value);
extern int  textgetbackblink(int x, int y);
extern void textputfore(int x, int y, int value);
extern int  textgetfore(int x, int y);

#define getkluttblink(ascii,fore,back,blink) ( ((ascii)&255) + (((fore)&15)<<8) + (((back)&15)<<12) + ((!!(blink))<<15) )
#define getklutt16(ascii,fore,back)          ( ((ascii)&255) + (((fore)&15)<<8) + (((back)&15)<<12) )
extern int getkluttmaskblink(int ascii,int fore,int back,int blink);
extern int getkluttmask16(int ascii,int fore,int back);

#endif
