/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for drawing on the text screen.

*/
#ifndef s_temo_c
#define s_temo_c

#include "s_temo.h"
#include "s_text.h"

#include <conio.h>
#include <stdio.h>
#include <sys/movedata.h>



/*********************
****              ****
**** current fore ****
****              ****
**********************
Gets/sets the foreground color for further text output in textmode.
*/
int textgetcurrentfore(void)
{
struct text_info textinfo;
gettextinfo(&textinfo);
return textinfo.attribute&15;
}
inline void textsetcurrentfore(int _color)//Only to be able to use my syntax.
{
textcolor(_color);
}
/*********************
****              ****
**** current back ****
****              ****
**********************
Gets/sets the background color for further text output in textmode.
*/
int textgetcurrentback(void)
{
struct text_info textinfo;
gettextinfo(&textinfo);
return (textinfo.attribute&15)>>4;
}
inline void textsetcurrentback(int _color)//Only to be able to use my syntax.
{
textbackground(_color);
}
/**********************
****               ****
**** current blink ****
****               ****
***********************
Gets/sets the blinking mode for further text output in textmode.
TRUE=blink on, FALSE=blink off.
*/
int textgetcurrentblink(void)
{
struct text_info textinfo;
gettextinfo(&textinfo);
return (textinfo.attribute>127) ? TRUE : FALSE;
}
void textsetcurrentblink(int onoff)
{
struct text_info textinfo;
gettextinfo(&textinfo);
if(onoff)
	textattr(textinfo.attribute|128);
else
	textattr(textinfo.attribute&127);
}
/*********************
****              ****
**** current attr ****
****              ****
**********************
Gets/sets all the formatting at the same time for further text output in
textmode. (Foreground and background color and blink mode.)
*/
int textgetcurrentattr(void)
{
struct text_info textinfo;
gettextinfo(&textinfo);
return textinfo.attribute;
}
inline void textsetcurrentattr(int _attr) //Only to be able to use my syntax.
{
textattr(_attr);
}




/*struct{
	int w,h;
}text_modes[]={
	{
int set_text_mode(int w,int h)
{
union REGS r;
r.h.al=0;
switch(w){
	case 80:
		switch(h){
			case 40:
				r.h.ah=
			break;
		}
	break;
}
int86(0x10,&r,&r);
}*/
/****************************
****                     ****
**** textgetscreenheight ****
****                     ****
*****************************
Returns the number of rows on the screen if you are in textmode.*/
int getscreenheight(void)
{
struct text_info textinfo;
gettextinfo(&textinfo);
return textinfo.screenheight;
}
/***************************
****                    ****
**** textgetscreenwidth ****
****                    ****
****************************
Returns the number of columns on the screen if you are in textmode.*/
int getscreenwidth(void)
{
struct text_info textinfo;
gettextinfo(&textinfo);
return textinfo.screenwidth;
}
/****************************
****                     ****
**** textsetscreenheight ****
****                     ****
*****************************
Sets the number of rows on the screen if you are in textmode. This is exactly
the same as the standard function _set_screen_lines, except that it returns
0 on success and -1 if it couldn't set to the screen mode.*/
int setscreenheight(int numrows)
{
struct text_info textinfo;
_set_screen_lines(numrows);
gettextinfo(&textinfo);
return (textinfo.screenheight==numrows) ? 0 : -1;
}



/************************
****                 ****
**** textoutlinerect ****
****                 ****
*************************
Draws an outline rectangle on the dos text screen.
If x and y are zero, the rectangle is at the top left of screen. w and h
means the number of characters of width that the box has. This means that
x+w is the first point where no character is drawn. If you specify x=0 and
w=80 (width of screen), the rectangle will fill the entire screen in the
x-direction.
Pass `al_center' to x or y to automatically center the box.
*/
void textoutlinerect(int x,int y,int w,int h,int klutt,int kluttmask)
{
if(x==al_center)
	x=d2(getscreenwidth()-w);
if(y==al_center)
	y=d2(getscreenheight()-h);
texthline(x,y,w,klutt,kluttmask);
textvline(x,y,h,klutt,kluttmask);
texthline(x,y+h-1,w,klutt,kluttmask);
textvline(x+w-1,y,h,klutt,kluttmask);
}

/*********************
****              ****
**** textfillrect ****
****              ****
**********************
Draws a filled rect in the same way as textoutlinerect draws its outline rect.
*/
void textfillrect(int x,int y,int w,int h,int klutt,int kluttmask)
{
int screenwidth=getscreenwidth(),screenheight=getscreenheight();
int leftaddress,posaddress,leftendaddress,posendaddress;
int newklutt;

//Clipping x and w.
if(x==al_center)
	x=d2(screenwidth-w);//Center.

if(x<0){
	w+=x;
	x=0;
}else if(x>=screenwidth)
	return;

if(w<1)
	return;
if((x+w)>screenwidth)
	w=screenwidth-x;

//Clipping y and h.
if(y==al_center)
	y=d2(screenheight-y);//Center.

if(y<0){
	y+=h;
	y=0;
}else if(y>=screenheight)
	return;

if(h<1)
	return;
if((y+h)>=screenheight)
	h=screenheight-y;

//Doing the drawing.
klutt&=kluttmask;
kluttmask=~kluttmask;//Invert it.
cm2(w);
leftaddress=screenstart+m2(x)+m160(y);
leftendaddress=leftaddress+m160(h);
while(leftaddress<leftendaddress){
	posaddress=leftaddress;
	posendaddress=posaddress+w;
	while(posaddress<posendaddress){
		dosmemget(posaddress,2,&newklutt);
		newklutt&=kluttmask;
		newklutt|=klutt;
		dosmemput(&newklutt,2,posaddress);
		posaddress+=2;
	}
	leftaddress+=160;
}
}



/******************
****           ****
**** texthline ****
****           ****
*******************
Draws a horizontal line on a textscreen.
*/
void texthline(int x,int y,int w,int klutt,int kluttmask)
{
int screenwidth=getscreenwidth();
int newklutt;

//Clipping x and w.
if(x==al_center)
	x=d2(screenwidth-w);

if(x<0){
	w+=x;
	x=0;
}else if(x>=screenwidth)
	return;

if(w<1)
	return;
if((w+x)>=screenwidth)
	w=screenwidth-x;

//Clipping y.
if((y<0)||(y>=getscreenheight()))
	return;

/*x is now used as the first point and w is used as the last.*/
x=screenstart+m2(x)+m160(y);
w=x+m2(w);
klutt&=kluttmask;
kluttmask=~kluttmask;
while(x<w){
	dosmemget(x,2,&newklutt);
	newklutt&=kluttmask;
	newklutt|=klutt;
	dosmemput(&newklutt,2,x);
	x+=2;
}
}

/******************
****           ****
**** textvline ****
****           ****
*******************
Draws a vertical line on a textscreen.
*/
void textvline(int x,int y,int h,int klutt,int kluttmask)
{
int screenheight=getscreenheight();
int newklutt;

//Clipping y and h.
if(y==al_center)
	y=d2(screenheight-h);

if(y<0){
	h+=y;
	y=0;
}else if(y>=screenheight)
	return;

if(h<1)
	return;
if((y+h)>=screenheight)
	h=screenheight-y;

//Clipping x.
if((x<0)||(x>=getscreenwidth()))
	return;

/*y is now used as the first point and h is used as the last.*/
y=screenstart+m2(x)+m160(y);
h=y+m160(h);
klutt&=kluttmask;
kluttmask=~kluttmask;
while(y<h){
	dosmemget(y,2,&newklutt);
	newklutt&=kluttmask;
	newklutt|=klutt;
	dosmemput(&newklutt,2,y);
	y+=160;
}
}




/*Returns a kluttmask, which is an integer where the 1-s tell which parts of
a klutt that shall be drawn. This is for video modes where the last bit in
the klutt mean blinking text*/
int getkluttmaskblink(int ascii,int fore,int back,int blink)
{
int ret;
if(ascii)
	ret=255;
else
	ret=0;
if(fore)
	ret|=(15<<8);
if(back)
	ret|=(7<<12);
if(blink)
	ret|=(1<<15);
return ret;
}
/*Returns a kluttmask, which is an integer where the 1-s tell which parts of
a klutt shall be drawn. This is for video modes supporting 16 background
colors, but not blinking text.*/
int getkluttmask16(int ascii,int fore,int back)
{
int ret;
if(ascii)
	ret=255;
else
	ret=0;
if(fore)
	ret|=(15<<8);
if(back)
	ret|=(15<<12);
return ret;
}


//Sets/gets only the blinkmode for a klutt on screen.
void textputblink(int x, int y, int value)
{
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(),getscreenheight())))
	return;
if(value){
	dosmemget(screenstart+m2(x)+m160(y)+1, 1, &value);
	value=(value&127)+128;
}else{
	dosmemget(screenstart+m2(x)+m160(y)+1, 1, &value);
	value=value&127;
}
dosmemput(&value, 1, screenstart+m2(x)+m160(y)+1);
}
int textgetblink(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(),getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &value);
return !!((value)&128);
}

//Sets only the background color for a klutt on screen, if there are 16
//background colors and no blink bit.
void textputback16(int x, int y, int value)
{
int oldvalue;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &oldvalue);
value=(oldvalue&(~(15<<4))) + ((value&15)<<4);
dosmemput(&value, 1, screenstart+m2(x)+m160(y)+1);
}
int textgetback16(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &value);
return (value&(15<<4)) >> 4;
}

//Sets only the background color for a klutt on screen, if there are 8
//background colors and one blink bit.
void textputbackblink(int x, int y, int value)
{
int oldvalue;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &oldvalue);
value=(oldvalue&(~(7<<4))) + ((value&7)<<4);
dosmemput(&value, 1, screenstart+m2(x)+m160(y)+1);
}
int textgetbackblink(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &value);
return (value&(7<<4)) >> 4;
}

//Sets only the foreground color for a klutt on screen.
void textputfore(int x, int y, int value)
{
int oldvalue;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &oldvalue);
value=(oldvalue&(~15))+(value&15);
dosmemput(&value, 1, screenstart+m2(x)+m160(y)+1);
}
int textgetfore(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y)+1, 1, &value);
return (value&15);
}


//Get/set one character on screen.
int textgetchar(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y),1,&value);
return value;
}
void textputchar(int x,int y,int value)
{
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return;
dosmemput(&value, 1, screenstart+m2(x) + m160(y));
}
//Gets/sets the whole formatting for one klutt on screen.
int textgetattr(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y)+1,1,&value);
return value;
}
void textputattr(int x,int y,int value)
{
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return;
dosmemput(&value, 1, screenstart+m2(x) + m160(y) + 1);
}
//Gets/sets a whole klutt on the screen.
int textgetklutt(int x, int y)
{
int value;
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return -1;
dosmemget(screenstart+m2(x)+m160(y),2,&value);
return value;
}
void textputklutt(int x,int y,int value)
{
if(!pointinrect(v2point(x,y),v2rect(0,0,getscreenwidth(), getscreenheight())))
	return;
dosmemput(&value, 2, screenstart+m2(x) + m160(y));
}

#endif
