/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains miscellaneous functions that don't belong anywhere else.

*/
#ifndef s_common_c
#define s_common_c

#include "s_common.h"

#include "s_string.h"

#include <allegro.h>

#include <string.h>
#include <stdio.h>
#include <math.h>
#include <conio.h>





/**************
****       ****
**** nofun ****
****       ****
***************
No function: a function that doesn't do anything. Use this to place a
breakpoint on the call.*/
int nofun_dummy_variable=0;
int nofun(void)
{
return nofun_dummy_variable++;
}



/**************
****       ****
**** memor ****
****       ****
***************
Does binary or on buf1 and buf2, and stores the result in buf1, which it
returns.*/
void *memor(void *buf1,void *buf2,ulong length)
{
while(length--)
	*(((uchar*)buf1)+length) |= *(((uchar*)buf2)+length);
return buf1;
}


/****************
****         ****
**** keywait ****
****         ****
*****************
Stops the program until a key is pressed. Also clears the keyboard buffer.
After a call to this, no keys will be in the buffer.*/
int keywait(void)
{
int the_key;
clear_keybuf();
the_key=readkey();
clear_keybuf();
return the_key;
}

/*********************
****              ****
**** keymousewait ****
****              ****
**********************
Stops the program until a key or mouse button is pressed. Also clears the
keyboard buffer. After a call to this, no keys will be in the buffer.*/
int keymousewait(void)
{
int available_mouse_b = ~mouse_b;
int the_key;
clear_keybuf();
while(1){
	if(keypressed()){
		the_key=readkey();
		clear_keybuf();
		return the_key;
	}
	//Only mouse buttons that have been up are recognized.
	if(mouse_b & available_mouse_b)
		return -1;
	available_mouse_b |= ~mouse_b;
}
}


/******************
****           ****
**** dos_getyn ****
****           ****
*******************
NOT FOR USE WITH ALLEGRO! Waits till y or n is pressed, and returns which of
them it was. Also prints it.
*/
uchar dos_getyn(void)
{
int ascii;
do{
	ascii=chartolower(getch());
}while((ascii!='n')&&(ascii!='y'));
cprintf("%c",ascii);
return ascii;
}


#endif
