#include <allegro.h>
#include <salad.h>

int out_proc(int msg, DIALOG *d, int c);
int out_viahue_proc(int msg, DIALOG *d, int c);
int out_viacolor_proc(int msg, DIALOG *d, int c);
int in_proc(int msg, DIALOG *d, int c);
int in_viahue_proc(int msg, DIALOG *d, int c);
int in_viacolor_proc(int msg, DIALOG *d, int c);
int to_hue_proc(int msg, DIALOG *d, int c);
int to_color_proc(int msg, DIALOG *d, int c);
int update(void *dp3, int d2);
int help_proc(int msg, DIALOG *d, int c);

uchar *help_text = NULL;

#define max_bmps  (20)
BITMAP *bmps[max_bmps];
PALETTE pals[max_bmps];

int fade_time = 500;
//Must have integers since the `dp3' field should point to these.
int via_color_red = 63, via_color_green = 0, via_color_blue = 0;
RGB via_color = {63, 0, 0};

int light_color_index, dark_color_index;

int num_bmps = 0, current_bmp = 0;

//Indexes in dialog.
#define bmp_index          (0)
#define first_button_index (17)
#define last_button_index  (25)
DIALOG dia[] =
{
	/*(dialog proc)      (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp)     (dp2)          (dp3) */
	{ d_bitmap_proc,     0,    0,    640,  200,  0,    0,    0,    0,       0,    0,    NULL },
	{ d_slider_proc,     200,  200,  256,  16,   0,    0,    0,    0,       512,  256,  NULL,    update,        &fade_curviness },
	{ d_slider_proc,     200,  220,  256,  16,   0,    0,    0,    0,       512,  256,  NULL,    update,        &fade_lum },
	{ d_slider_proc,     200,  240,  256,  16,   0,    0,    0,    0,       256,  256,  NULL,    update,        &fade_amount },
	{ d_slider_proc,     200,  260,  256,  16,   0,    0,    0,    0,       256,  256,  NULL,    update,        &fade_via_amount },
	{ d_slider_proc,     200,  280,  256,  16,   0,    0,    0,    0,       5000, 500,  NULL,    update,        &fade_time },
	{ d_slider_proc,     200,  300,  256,  16,   0,    0,    0,    0,       63,   63,   NULL,    update,        &via_color_red },
	{ d_slider_proc,     200,  320,  256,  16,   0,    0,    0,    0,       63,   0,    NULL,    update,        &via_color_green },
	{ d_slider_proc,     200,  340,  256,  16,   0,    0,    0,    0,       63,   0,    NULL,    update,        &via_color_blue },
	{ d_text_proc,       0,    205,  0,    0,    0,    0,    0,    0,       0,    0,    "`fade_curviness'"  },
	{ d_text_proc,       0,    225,  0,    0,    0,    0,    0,    0,       0,    0,    "`fade_lum'"  },
	{ d_text_proc,       0,    245,  0,    0,    0,    0,    0,    0,       0,    0,    "`fade_amount'"  },
	{ d_text_proc,       0,    265,  0,    0,    0,    0,    0,    0,       0,    0,    "`fade_via_amount'"  },
	{ d_text_proc,       0,    285,  0,    0,    0,    0,    0,    0,       0,    0,    "Time (milliseconds)"  },
	{ d_text_proc,       0,    305,  0,    0,    0,    0,    0,    0,       0,    0,    "           red"  },
	{ d_text_proc,       0,    325,  0,    0,    0,    0,    0,    0,       0,    0,    "Via color: green"  },
	{ d_text_proc,       0,    345,  0,    0,    0,    0,    0,    0,       0,    0,    "           blue"  },
	{ out_proc,          20,   360,  200,  20,   0,    0,    0,    0,       0,    0,    "fadeout()" },
	{ out_viahue_proc,   220,  360,  200,  20,   0,    0,    0,    0,       0,    0,    "fadeout_viahue()" },
	{ out_viacolor_proc, 420,  360,  200,  20,   0,    0,    0,    0,       0,    0,    "fadeout_viacolor()" },
	{ in_proc,           20,   380,  200,  20,   0,    0,    0,    0,       0,    0,    "fadein()" },
	{ in_viahue_proc,    220,  380,  200,  20,   0,    0,    0,    0,       0,    0,    "fadein_viahue()" },
	{ in_viacolor_proc,  420,  380,  200,  20,   0,    0,    0,    0,       0,    0,    "fadein_viacolor()" },
	{ to_hue_proc,       220,  400,  200,  20,   0,    0,    0,    0,       0,    0,    "fadeto_hue()" },
	{ to_color_proc,     420,  400,  200,  20,   0,    0,    0,    0,       0,    0,    "fadeto_color()" },
	{ d_button_proc,     220,  420,  200,  20,   0,    0,    0,    D_EXIT,  0,    0,    "Quit" },
	{ help_proc,         0,    445,  640,  35,   0,    0,    0,    0,       0,    0,    NULL },
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
};
uchar *helps[] = {
	NULL,
	"Alters how the fading will accellerate. Fading could go slow in the beginning and fast in the end, or vice versa.",
	"Alters how the fading speed will differ between different colors. You could make dark colors fade faster than light colors, or vice versa.",
	"Alters how long the fading will go. You could make it stop at half way if you want.",
	"Alters how long the fading will go for the via color. You could make the effect stronger or weaker using this.",
	"Sets how long the time the fading will go on. Measured in milliseconds.",
	"The color to fade via in the `fade*_via_*()' routines. This is the red component.",
	"The color to fade via in the `fade*_via_*()' routines. This is the green component.",
	"The color to fade via in the `fade*_via_*()' routines. This is the blue component.",
	NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	"Fades out.",
	"Fades out via the color specified above. The hue for the source colors will gradually fade towards the hue of the specified color while fading to black.",
	"Fades out via the color specified above. The source colors will gradually fade towards the specified color while fading to black.",
	"Fades in.",
	"Fades in via the color specified above. The hue for the dest colors will gradually fade from the hue of the specified color to their own color while fading from black.",
	"Fades in via the color specified above. The source colors will gradually fade from the specified color to their own color while fading from black.",
	"Fades the hue of all colors towards the color specified above.",
	"Fades all colors towards the color specified above.",
	"Exits this example program.",
	NULL,
	NULL
};



/******************
****           ****
**** help_proc ****
****           ****
*******************
The dialog object that displays help.
*/
int last_mouse_object;
int help_proc(int msg, DIALOG *d, int c)
{
TRECT help_window = v2rect(d->x, d->y, d->w, d->h);
int mouse_object = 0;
int i;
for(i = 0; dia[i].proc; i++)
	if(dia[i].flags & D_GOTMOUSE){
		mouse_object = i;
		break;
	}
if(mouse_object != last_mouse_object){
	before_draw(screen, help_window);
	trect_rectfill(screen, help_window, dark_color_index);
	if(helps[mouse_object])
		textbox(screen, font, helps[mouse_object], help_window,
		 al_centre, al_centre, light_color_index);
	last_mouse_object = mouse_object;
	after_draw();
}
return D_O_K;
}



/**********************
****               ****
**** draw_the_text ****
****               ****
***********************
Draws the info text telling values of all variables.
*/
void draw_the_text(void)
{
TRECT textrect = v2rect(460, 205, 200, 150);
//Eventually hide the mouse.
before_draw(screen, textrect);
//Draw text.
text_mode(dark_color_index);
trect_rectfill(screen, textrect, dark_color_index);
textprintf(screen, font, 460, 205, light_color_index, "%d", fade_curviness);
textprintf(screen, font, 460, 225, light_color_index, "%d", fade_lum);
textprintf(screen, font, 460, 245, light_color_index, "%d", fade_amount);
textprintf(screen, font, 460, 265, light_color_index, "%d", fade_via_amount);
textprintf(screen, font, 460, 285, light_color_index, "%d", fade_time);
textprintf(screen, font, 460, 305, light_color_index, "%d", (int)via_color.r);
textprintf(screen, font, 460, 325, light_color_index, "%d", (int)via_color.g);
textprintf(screen, font, 460, 345, light_color_index, "%d", (int)via_color.b);
after_draw();
}

/***************
****        ****
**** update ****
****        ****
****************
The callback for the sliders.*/
int update(void *dp3, int d2)
{
//Init the variable that changed.
if((dp3 == &fade_curviness) || (dp3 == &fade_lum))
	*(int*)dp3 = d2 - 256;
else
	*(int*)dp3 = d2;
via_color = v2rgb(via_color_red, via_color_green, via_color_blue);

draw_the_text();

return D_O_K;
}



/*************
****      ****
**** next ****
****      ****
*************/
/* Called from `next_infading()' and `next_outfading()'. Jumps to next bitmap
	and finds out the lightest and darkest colors in the palette (used when
	drawing the text).
	Also resets all buttons so that none is pressed down.
*/
void next(void)
{
int i;
current_bmp = (current_bmp + 1) % num_bmps;
dia[bmp_index].dp = bmps[current_bmp];
light_color_index = bestfit_color(pals[current_bmp], 63, 63, 63);
dark_color_index  = bestfit_color(pals[current_bmp], 0,  0,  0);
for(i = 0; dia[i].proc; i++){
	dia[i].fg = light_color_index;
	dia[i].bg = dark_color_index;
}
//Clear selected flag. Otherwise the button may be pressed down later.
for(i = first_button_index; i <= last_button_index; i++)
	dia[i].flags &= ~D_SELECTED;

//Force the help to update if needed.
last_mouse_object = 0;

clear(screen);
}

/* Called before the fading starts from the in_*_proc button procs.
*/
void next_infading(void)
{
//Darken screen.
set_palette(black_palette);
//Next bitmap.
next();
//Redraw dialog and wait for input.
broadcast_dialog_message(MSG_DRAW, 0);
draw_the_text();
keymousewait();
}

/* Called after fading from the `out_*_proc()' and `to_*_proc()' button.
*/
void next_outfading(void)
{
//Wait for input.
keymousewait();
//Next bitmap.
next();
//Redraw dialog.
set_palette(pals[current_bmp]);
broadcast_dialog_message(MSG_DRAW, 0);
draw_the_text();
}


/****************************
****                     ****
**** fading button procs ****
****                     ****
*****************************
Dialog procs for the fading buttons.
*/
//`out_proc'
int out_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	fadeout(fade_time);
	next_outfading();
}
//One of the dialog procs should draw the text initially.
if(msg == MSG_START)
	draw_the_text();
return d_button_proc(msg, d, c);
}
//`out_viahue_proc'
int out_viahue_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	fadeout_viahue(fade_time, via_color);
	next_outfading();
}
return d_button_proc(msg, d, c);
}
//`out_viacolor_proc'
int out_viacolor_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	fadeout_viacolor(fade_time, via_color);
	next_outfading();
}
return d_button_proc(msg, d, c);
}
//`in_proc'
int in_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	next_infading();
	fadein(fade_time, pals[current_bmp]);
}
return d_button_proc(msg, d, c);
}
//`in_viahue_proc'
int in_viahue_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	next_infading();
	fadein_viahue(fade_time, pals[current_bmp], via_color);
}
return d_button_proc(msg, d, c);
}
//`in_viacolor_proc'
int in_viacolor_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	next_infading();
	fadein_viacolor(fade_time, pals[current_bmp], via_color);
}
return d_button_proc(msg, d, c);
}
//`to_hue_proc'
int to_hue_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	fadeto_hue(fade_time, via_color);
	next_outfading();
}
return d_button_proc(msg, d, c);
}
//`to_color_proc'
int to_color_proc(int msg, DIALOG *d, int c)
{
if(msg == MSG_CLICK){
	fadeto_color(fade_time, via_color);
	next_outfading();
}
return d_button_proc(msg, d, c);
}



void try_loading_bitmap(uchar *filename)
{
if(num_bmps <= max_bmps){
	bmps[num_bmps] = load_bitmap(filename, pals[num_bmps]);
	if(bmps[num_bmps])
		num_bmps++;
}
}



/*************
****      ****
**** main ****
****      ****
*************/
int main(int argc, char *argv[])
{
int i;
uchar *allegro_path;

//Install system.
allegro_init();
if(gfxmode(640,480))
	exitfail("Couldn't set graphics mode!");
install_timer();
install_keyboard();
install_mouse();
//if(install_mouse() == -1);
// exitfail("Couldn't install mouse!");
salad_init();
fade_curviness = fade_lum = 0;
fade_amount = fade_via_amount = 256;

//Load bitmaps.
allegro_path = getenv("ALLEGRO");
if(!allegro_path)
	allegro_path = addfilename_new(getenv("DJDIR"), "allegro");
try_loading_bitmap(changefilename_new(argv[0], "salad.pcx"));
try_loading_bitmap(addfilename_new(allegro_path, "examples\\allegro.pcx"));
try_loading_bitmap(addfilename_new(allegro_path, "examples\\mysha.pcx"));
//Load bitmaps from parameters.
for(i = 1; i < argc; i++)
	try_loading_bitmap(argv[i]);

//If we didn't find any bitmaps.
if(num_bmps == 0)
	exitfail("Couldn't find any bitmaps! You must pass the names of bitmaps files as\n"
	 "parameters.");

//Install dialog.
current_bmp = 0;
dia[bmp_index].dp = bmps[current_bmp];
set_palette(pals[current_bmp]);

light_color_index = bestfit_color(pals[current_bmp], 63, 63, 63);
dark_color_index  = bestfit_color(pals[current_bmp], 0,  0,  0);

for(i = 0; dia[i].proc; i++){
	dia[i].fg = light_color_index;
	dia[i].bg = dark_color_index;
}

//Run.
do_dialog(dia,0);

allegro_exit();
printf(
"Salad Example\n"
"Example of the extended fading functions in Salad by Sven Sandberg.\n"
"\n"
"The functions have the same names as the buttons. For each of those functions,\n"
"there is also a corresponding function suffixed with `_range', that only fades\n"
"part of the palette.");

return 0;
}

