/*
pdemo.c - demo programm for Palantir
Version : 0.3
Copyright 1997 Dim Zegebart, Moscow Russia.
E-mail zager@post.comstar.ru
http://www.geocities.com/siliconvalley/pines/7817
Tel. in Moscow (095)9560389
Fax. in Moscow (095)9563540
*/
/* This all-in-one example. It shows how to create applications and
install 'clients' for hardware (mouse,keyboard,comms)
*/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <palantir.h>
#include <io.h>

inline void dz_print_comm_err() {printf("%s",szDZCommErr);fflush(stdout);}

//--------------------- ONE OF IDLE PROC ---------------------
int prev_time=59;
int show_time(void)
{ struct time now;
  int tmp;
  int x,y;

  real_time_clock(0,&now);
  if (prev_time==now.ti_sec) return(1);
  prev_time=now.ti_sec;

  lwp_disable;
  x=wherex();
  y=wherey();
  gotoxy(70,1);
  printf("%d:%d:%d   \n",now.ti_hour,now.ti_min,now.ti_sec);
  gotoxy(x,y);
  lwp_enable;

  return(1);
}

int com2_handler(a_message code,int p1,int p2)
{ int tmp; //variable used by lwp_enable(disable) macros

  switch(code)
   { case APP_START:
      break;
     case H_COMM_IN:
      if (p1==0) p1=' ';
      lwp_disable;
      putch(p1);
      lwp_enable;
      break;
     case APP_STOP:
      return(0);
      break;
     default:
      break;
   }

 return(1);
}

int keyboard_handler(a_message code,int p1,int p2)
{ int tmp;
  int c=p1;
  byte ch;

  if (code==H_KEYBOARD)
   { if (ctrl_(c,'Q'))
      { palantir_deinit();
        return(1);
      }

     ch=ascii_(c);
     lwp_disable;
//     putch(ch);
     lwp_enable;
     comm_port_out(com2,ch);
   }
  return(1);
}

int mouse_handler(a_message code,int p1,int p2)
{ int c=p1;
  int x,y,b;
  int tmp;

  b=but_(c);
  x=x_(c);
  y=y_(c);

  lwp_disable;
  switch (code)
   { case APP_START:
       break;
     case H_MOUSE:
       printf("X: %d, Y: %d, B: %d\n",x,y,b);
       switch (b)
        { case E_LDBL_CLICK: printf(" LEFT DBL_CLICKED\n");
           break;
          case E_L_DOWN: printf(" LEFT PRESSED\n");
           break;
          case E_L_UP: printf(" LEFT RELEASED\n");
           break;
          case E_L_CLICK: printf(" LEFT CLICKED\n");
           break;
          case E_RDBL_CLICK: printf(" RIGHT DBL_CLICKED\n");
           break;
          case E_R_DOWN: printf(" RIGHT PRESSED\n");
           break;
          case E_R_UP: printf(" RIGHT RELEASED\n");
           break;
          case E_R_CLICK: printf(" RIGHT CLICKED\n");
           break;
           case E_MDBL_CLICK: printf(" MID DBL_CLICKED\n");
           break;
          case E_M_DOWN: printf(" MID PRESSED\n");
           break;
          case E_M_UP: printf(" MID RELEASED\n");
           break;
          case E_M_CLICK: printf(" MID CLICKED\n");
           break;
          default:
           if (b&E_L_PRESSED) printf(" LEFT IN PRESSED STATE\n");
           if (b&E_R_PRESSED) printf(" RIGHT IN PRESSED STATE\n");
           if (b&E_M_PRESSED) printf(" MID IN PRESSED STATE\n");
           break;
        }
       break;
     case APP_STOP:
       return(0);
       break;
     default:
       break;
    }
  lwp_enable;
  return(1);
}

int main(void)
{
  dz_app *keyb_app;
  dz_app *mice_app;
  dz_app *port2_app;

  clrscr();
// Palantir init
  if (palantir_init(DEV_KEYBOARD|DEV_MOUSE|DEV_COMMS)==FALSE) return(0);

// Installing mouse handler
  if ((mice_app=dz_app_new("MICE APP",4096,1,mouse_handler))==NULL) exit(255);
  device_client_task_add(mouse_device,mice_app,READ);

// Installing keyboard handler
  keyb_app=dz_app_new("KBD APP",4096,1,keyboard_handler);
  device_client_task_add(keyboard_device,keyb_app,READ);

// Installing com2 handler
  if (comm_port_init(_com2)==NULL)
   { dz_print_comm_err();
     exit(1);
   }
  comm_port_load_settings(com2,"ports.ini");
//  strcpy(com2->szName,"COM2-Modem (type command) :");
//  cdport_(com2)->nBaud=_115200;
//  cdport_(com2)->control_type=RTS_CTS;
  if (!comm_port_install_handler(com2))
   { dz_print_comm_err();
     exit(1);
   }
  port2_app=dz_app_new("PORT2 APP",4096,1,com2_handler);
  device_client_task_add(com2,port2_app,READ);

// Adding clock
  idle_proc_add(show_time);

// Entering main loop
  lwp_wait_true(&exit_program);

  return(0);
}
