/**[txh]********************************************************************

  Description:
  That's the second example for Palantir.
  The objetive is to collect mouse events and show the information on the
screen. Don't forget to read ex1.c first.

  Copyright (c) 1997 by Salvador Eduardo Tropea (SET)
  e-mail: salvador@inti.gov.ar or set-soft@usa.net

  Parts of this code:
  Copyright 1997 Dim Zegebart, Moscow Russia.
  e-mail zager@post.comstar.ru

  You can do anything with this code but:

1) You can't remove the copyright.
2) You can't blame me for any reason.

***************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <palantir.h>
#include <io.h>

#define LWPEnDisableUsed int tmp

/**[txh]********************************************************************

  Description:
  That's our Mouse Handler application.
  It will receive messages from the mouse.

***************************************************************************/

int mouse_handler(a_message code,int p1,int p2)
{
 LWPEnDisableUsed;
 int c=p1;
 int x,y,b;

 // Button flags
 b=but_(c);
 // X,Y coordinates
 x=x_(c);
 y=y_(c);

 lwp_disable;
 switch (code)
   {
    // We have a dummy for the application start. (Optional)
    case APP_START:
         break;
    // An event from the mouse
    case H_MOUSE:
         printf("X: %d, Y: %d, B: %d\n",x,y,b);
         switch (b)
           {
            case E_LDBL_CLICK:
                 printf(" LEFT DBL_CLICKED\n");
                 break;
            case E_L_DOWN:
                 printf(" LEFT PRESSED\n");
                 break;
            case E_L_UP:
                 printf(" LEFT RELEASED\n");
                 break;
            case E_L_CLICK:
                 printf(" LEFT CLICKED\n");
                 break;
            case E_RDBL_CLICK:
                 printf(" RIGHT DBL_CLICKED\n");
                 break;
            case E_R_DOWN:
                 printf(" RIGHT PRESSED\n");
                 break;
            case E_R_UP:
                 printf(" RIGHT RELEASED\n");
                 break;
            case E_R_CLICK:
                 printf(" RIGHT CLICKED\n");
                 break;
            case E_MDBL_CLICK:
                 printf(" MID DBL_CLICKED\n");
                 break;
            case E_M_DOWN:
                 printf(" MID PRESSED\n");
                 break;
            case E_M_UP:
                 printf(" MID RELEASED\n");
                 break;
            case E_M_CLICK:
                 printf(" MID CLICKED\n");
                 break;
            default:
                 if (b&E_L_PRESSED)
                    printf(" LEFT IN PRESSED STATE\n");
                 if (b&E_R_PRESSED)
                    printf(" RIGHT IN PRESSED STATE\n");
                 if (b&E_M_PRESSED)
                    printf(" MID IN PRESSED STATE\n");
                 break;
           }
         fflush(stdout);
         break;
     // When we receive STOP we just do nothing and agree to stop returning 0
     // The STOP is generated by the palantir_deinit(); in the
     // keyboard_handler
     case APP_STOP:
          return 0;
          break;
     default : break;
    }
 lwp_enable;
 return 1;
}


/**[txh]********************************************************************

  Description:
  That's our Keyboard Handler application.
  It will receive messages from the keyboard.
  In this example we use it only to finish the program pressing Ctrl+Q

***************************************************************************/

int keyboard_handler(a_message code,int p1,int p2)
{
 int c=p1;

 if (code==H_KEYBOARD)
   {
    if (ctrl_(c,'Q'))
      {
       palantir_deinit();
       return 1;
      }
   }
 return 1;
}


int main(void)
{
 LWPEnDisableUsed;
 // That's the pointer to our keyboard application
 dz_app *mice_app;
 dz_app *keyb_app;

 clrscr();
 // Init Palantir using keyboard and mouse
 if (palantir_init(DEV_KEYBOARD | DEV_MOUSE)==FALSE)
   {
    printf("Error: Palantir initialization failed\n");
    return 1;
   }

 // Now create the new application with:
 // Name="KBD APP", Stack=4K, Priority=1 (1 time slice per turn) and this
 // application will process the messages through keyboard_handler
 // Just used to stop the program with Ctrl+Q
 keyb_app=dz_app_new("KBD APP",4096,1,keyboard_handler);
 // And other for the mouse
 if ((mice_app=dz_app_new("MICE APP",4096,1,mouse_handler))==NULL)
   {
    printf("Error: Failed to create the mouse application\n");
    return 2;
   }
 // Now "connect" our keyboard application with the keyboard device
 device_client_task_add(keyboard_device,keyb_app,READ);
 // And the mouse application
 device_client_task_add(mouse_device,mice_app,READ);

 lwp_disable;
 printf("Touch the mouse ...\nCtrl-Q to exit\n");
 lwp_enable;

 lwp_wait_true(&exit_program);
 return 0;
}
