#ifndef MX_H
#define MX_H


#include <stdarg.h>
#include "allegro.h"


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
                                  DEFINITIONS
 ******************************************************************************/

#define Null                           0
#define False                          FALSE
#define True                           TRUE


/* events */
#define WindowExpose                   1
#define ButtonPress                    2
#define ButtonDown                     4
#define ButtonRelease                  8
#define PointerStart                   16
#define PointerEnter                   32
#define PointerMove                    64
#define PointerLeave                   128
#define PointerStop                    256
#define KeyPress                       512


/******************************************************************************
                                     TYPES
 ******************************************************************************/


typedef int                            Bool;
typedef unsigned long                  ID;
typedef ID                             Window;
typedef ID                             Dialog;
typedef ID                             Cursor;


/******************************************************************************
                                  STRUCTURES
 ******************************************************************************/


typedef struct Rect {
   int x1;
   int y1;
   int x2;
   int y2;
} Rect;


typedef struct WindowInfo {
   Window window;
   int x1;
   int y1;
   int x2;
   int y2;
   int border_width;
   void *extension;
} WindowInfo;


typedef struct ExposeEvent {
   int type;
   int x1;
   int y1;
   int x2;
   int y2;
   int count;
} ExposeEvent;


typedef struct ButtonEvent {
   int type;
   int root_x;
   int root_y;
   int window_x;
   int window_y;
   Window pointer_child;
   int button;
   int clicks;
   int time;
} ButtonEvent;


typedef struct PointerEvent {
   int type;
   int root_x;
   int root_y;
   int window_x;
   int window_y;
   Window pointer_child;
   Window crossed_child;
} PointerEvent;


typedef struct KeyEvent {
   int type;
   int keyread;
} KeyEvent;


typedef union Event {
   int type;
   ExposeEvent expose;
   ButtonEvent button;
   PointerEvent pointer;
   KeyEvent key;
} Event;


/******************************************************************************
                                  FUNCTIONS
 ******************************************************************************/


Bool AddDialogWindow(Dialog dialog, Window window);
Bool CheckIfValidDepth(Window window, int depth);
Cursor CreateCursor(BITMAP *bmp, int x, int y);
Window CreateRootWindow( void *extension,
   void (*event_handler)(WindowInfo *, Event *));
Dialog CreateDialog(Cursor cursor,
   void (*event_handler)(Dialog, Event *), Window window, ...);
Window CreateWindow(Window parent, void *extension,
   void (*event_handler)(WindowInfo *, Event *), int x, int y, int width,
   int height, int border_width, int processed_events, int propagated_events);
Bool DestroyCursor(Cursor *cursor);
void DestroyDialog(Dialog *dialog);
void DestroyWindow(Window *window);
Bool DoWindowDrawing(Window window, Bool overwrite_children,
   void (*paint_function)(WindowInfo *, ExposeEvent *));
int GetWindowBorderWidth(Window window);
int GetClickThreshold();
Window GetXYChild(Window parent, int x, int y);
Window GetWindowBottomChild(Window window);
Dialog GetWindowDialog(Window window);
int GetWindowHeight(Window window);
Window GetWindowHigher(Window window);
int GetWindowInput(Window window);
Window GetWindowLower(Window window);
Window GetWindowParent(Window window);
Rect GetWindowPosition(Window window);
int GetWindowPropagation(Window window);
Window GetWindowTopChild(Window window);
Rect GetWindowViewport(Window window);
int GetWindowViewportHeight(Window window);
int GetWindowViewportWidth(Window window);
Bool GetWindowVisible(Window window);
int GetWindowWidth(Window window);
int GetWindowX(Window window);
int GetWindowY(Window window);
int GetWindowZOrder(Window window, int direction);
Bool GrabEvents(Window window);
void InitMX();
Bool InsertWindow(Window window, Window parent, int pos);
Bool InstallRootWindow(Window window);
Bool PaintWindow(Window window);
void RedirectKeyboard(Window window);
Bool RefreshWindow(Window window);
Bool ReleaseEvents(Window window);
Bool RemoveDialogWindow(Window window);
Bool RemoveWindow(Window window);
void RunDialog(Dialog *dialog);
void SendEventToWindow(Window window, Event *event);
void SetClickThreshold(int msecs);
void SetWindowBorderWidth(Window window, int val);
void SetWindowCursor(Window window, Cursor cursor);
void SetWindowHeight(Window window, int val);
void SetWindowInput(Window window, int val);
void SetWindowPropagation(Window window, int val);
void SetWindowWidth(Window window, int val);
void SetWindowX(Window window, int val);
void SetWindowY(Window window, int val);
Bool SetWindowZOrder(Window window, int pos);
void TranslateCoords(Window src, Window dst, int x, int y,
   int *outx, int *outy);
void UpdateWindowGeometry(Window window);


#ifdef __cplusplus
}
#endif


#endif MX_H

