#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <allegro.h>
#include <_string.h>
#include <string.h>
#include "globals.h"
#include "dialog.h"
#include "objhelp.h"
#include "mdk_desk.h"
#include "ids.h"
#include "pall.h"
#define BLIT show_mouse(NULL);blit(Gui_area,screen,0,0,X_GUI,Y_GUI,_W,_H);show_mouse(screen)
#define STRINGLENGTH 60
#define WAIT 1

/* 
 * 
 * class dialog 
 */
dialog::dialog(char* dummy) 
{
   ask_for_input="Draw the size";
   x=0;
   y=0;
   w=0;
   h=0;
   fg=FG;
   bg=BG;
   key="0";
   flags="0";
   d1=0;
   d2=0;
   dp="NULL";
   name="dialog";
   GuiNumber=0;
}
dialog::~dialog()
{
   delete ask_for_input;
}
void dialog::ListCounter(int LC)
{
 LCounter=LC;
};
void dialog::export()
{
   fout<<"\n"<<name<<"\t"<<x<<"\t"<<y<<"\t"<<w<<"\t"<<h<<"\t"<<fg;
   fout<<"\t"<<bg<<"\t"<<key<<"\t"<<flags<<"\t"<<d1<<"\t"<<d2;
   fout<<"\t"<<dp<<"\n";
}
void dialog::import()
{
   fin>>name>>x>>y>>w>>h>>fg;
   fin>>bg>>key>>flags>>d1>>d2;
   fin>>dp;
}
void dialog::SaveInit()
{
};
int dialog::saveColor32(int line_nr,String DialogName)
{
 fout<<"\n\t"<<DialogName<<"["<<line_nr<<"].fg=palette_color["<<fg<<"];";
 fout<<"\n\t"<<DialogName<<"["<<line_nr<<"].bg=palette_color["<<bg<<"];";
}
int dialog::save(int line_nr)
{
   fout<<"\n";
   GuiNumber=line_nr;
   if (WRITE_COLORS_STATIC!=D_SELECTED)
    {
      if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
      fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\t"<<fg;
      fout<<",\t"<<bg<<",\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
      fout<<" ,\t"<<dp<<"},";
    }
    else
    {
      if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
      fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\tpalette_color["<<fg;
      fout<<"],\tpalette_color["<<bg<<"],\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
      fout<<" ,\t"<<dp<<"},";
      }

}
int dialog::THIS(int xm,int ym)
{
   int xt=xm-X_GUI;
   int yt=ym-Y_GUI;
   if ( ( (xt>x) && (xt<(x+w))) &&  ( (yt>y) && (yt<(y+h)))) return 1;
   else return 0;
}
int dialog::inside(int xi,int yi,int wi,int hi)
{
   if ( (x>=xi) && (y>=yi) && ((x+w)<(xi+wi)) && ( (y+h)<(yi+hi))) return 1;
   return 0;
}
void dialog::copy (dialog& temp, int& xc, int& yc,int NoDeltaMove=0)
{
   if (!NoDeltaMove)
     {
        yc=yc+25;
        xc=xc+25;
        x=temp.x+grid(xc);
        y=temp.y+grid(yc);
     }
     else
     {
        x=temp.x;
        y=temp.y;
     }
   w=temp.w;
   h=temp.h;
   fg=temp.fg;
   bg=temp.bg;
   d1=temp.d1;
   d2=temp.d2;
   name=temp.name;
   flags=temp.flags;
   key=temp.key;
   dp=temp.dp;
   
};
int dialog::show_prop(int sfg,int sbg)
{
   char key_char[12];
   strcpy(key_char,key) ;
   char flag_char[STRINGLENGTH];
   strcpy(flag_char,flags);
   char data_pointer[STRINGLENGTH];
   strcpy(data_pointer,dp);
   char d1_feld[3];
   itoa(d1,d1_feld,10);
   char d2_feld[3];
   itoa(d2,d2_feld,10);
   
   char xt[4];
   itoa(x,xt,10);
   char yt[4];
   itoa(y,yt,10);
   
   char wt[4];
   itoa(w,wt,10);
   char ht[4];
   itoa(h,ht,10);
   
   char fgt[4];
   itoa(sfg,fgt,10);
   char bgt[4];
   itoa(sbg,bgt,10);
#define dpos 19
#define DX 250
#define dcol 20
#define dhelp 23
#define dmore 22
   DIALOG prop_dialog[]= { 
	{ d_shadow_box_proc , 304+DX ,        24 ,    228 ,   168 ,   palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     NULL},
	{ d_text_proc ,       316+DX ,        36 ,    72 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[TYPE_]},
	{ d_text_proc ,       364+DX ,        36 ,    144 ,   12 ,    palette_color[221] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,      name },
	{ d_text_proc ,       316+DX ,        48 ,    84 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[POSITION_]},
	{ d_text_proc ,       400+DX ,        48 ,    36 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      xt },
	{ d_text_proc ,       424+DX ,        48 ,    12 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      "," },
	{ d_text_proc ,       436+DX ,        48 ,    36 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      yt },
	{ d_text_proc ,       316+DX ,        60 ,    84 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[SIZE_W_H_] },
	{ d_text_proc ,       400+DX ,        60 ,    36 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      wt },
	{ d_text_proc ,       424+DX ,        60 ,    12 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      "," },
	{ d_text_proc ,       436+DX ,        60 ,    36 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      ht },
	{ d_text_proc ,       460+DX ,        98 ,    36 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      fgt },
	{ d_text_proc ,       484+DX ,        98 ,    12 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      "," },
	{ d_text_proc ,       496+DX ,        98 ,    36 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      bgt },
	{ d_text_proc ,       316+DX ,        120 ,   60 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[KEY_] },
	{ d_text_proc ,       316+DX ,        132 ,   60 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[FLAG_]},
	{ d_text_proc ,       316+DX ,        144 ,   84 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,      "<d1,d2>:" },
	{ d_text_proc ,       400+DX ,        144 ,   12 ,    12 ,    palette_color[143] ,   palette_color[96],    0 ,     0 ,     0 ,     0 ,      "," },
	{ d_text_proc ,       316+DX ,        156 ,   120 ,   12 ,    palette_color[31],    palette_color[96],    0 ,     0 ,     0 ,     0 ,     UserText[DATAPOINTER_]},
	{ d_button_proc ,     376+DX ,        72 ,    144 ,   12 ,    palette_color[31],    palette_color[96],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[CHANGE_POS_SIZE_] },
	{ d_button_proc ,     316+DX ,        96 ,    120 ,   12 ,    palette_color[31],    palette_color[96],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[COLORS_FG_BG_] },
	{ d_button_proc ,     328+DX ,        168 ,   48 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
	{ d_button_proc ,     388+DX ,        168 ,   72 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[MORE_] },
	{ d_button_proc ,     472+DX ,        168 ,   48 ,    12 ,    palette_color[31],    palette_color[96],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
	{ d_edit_proc ,       352+DX ,        120 ,   132 ,   12 ,    palette_color[140] ,   palette_color[96],    0 ,     0 ,     STRINGLENGTH ,  1 ,     key_char},
	{ d_edit_proc ,       364+DX ,        132 ,   132 ,   12 ,    palette_color[140] ,   palette_color[96],    0 ,     0 ,     STRINGLENGTH ,  1 ,     flag_char},
	{ d_edit_proc ,       424+DX ,        156 ,   96 ,    12 ,    palette_color[140] ,   palette_color[96],    0 ,     0 ,     STRINGLENGTH ,  1 ,     data_pointer},
	{ d_edit_proc ,       388+DX ,        144 ,   48 ,    12 ,    palette_color[140] ,   palette_color[96],    0 ,     0 ,     STRINGLENGTH ,  1 ,     d1_feld},
	{ d_edit_proc ,       412+DX ,        144 ,   48 ,    12 ,    palette_color[140] ,   palette_color[96],    0 ,     0 ,     STRINGLENGTH ,  1 ,     d2_feld},
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   centre_dialog(prop_dialog);
   popup_dialog(prop_dialog,-1);
   
   key=key_char;
   flags=flag_char;
   dp=data_pointer;
   d1=atoi(d1_feld);
   d2=atoi(d2_feld);
   
   if (prop_dialog[dhelp].flags==MSG_DCLICK) return -1;
   
   if (prop_dialog[dpos].flags==MSG_DCLICK)
     {
	pos();
	return 1;
     }
   
   if (prop_dialog[dmore].flags==MSG_DCLICK)
     {
	return 2;
     }
   if (prop_dialog[dcol].flags==MSG_DCLICK) return 0;
   
   return 1;
   
   
   
}
char* dialog::input() {return NULL;}
void dialog::write_defines(String DialogName,int DialogID){}
int dialog:: key_convert()
{
   return 0;
}
int dialog::flags_convert()
{
   if (flags=="D_SELECTED") return D_SELECTED;
   if (flags=="D_DISABLED") return D_DISABLED;
   return 0;
}

dialog::pos()
     {
	rect_preparer p;
	p.run();
	x=p.x;
	y=p.y;
	w=p.w;
	h=p.h;
     }



/*
 * 
 * The next classes explain themselves, the names are identical.
 * 
 * 
 * Clear-procs are unvisable. For better controlling I've drawn
 * a dotted rect.
 * 
 * */
gui_d_clear_proc::gui_d_clear_proc(char* dummy) : dialog(dummy)
{
   c=0;
   name="d_clear_proc";
   fg=33;
}
int gui_d_clear_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   
   if (fgd==33)
     {
	for (int tx=0;tx<=w;tx=tx+2)
	  {
	     putpixel(b,x+tx, y,palette_color[255]);
	     putpixel(b,x+tx, y+h,palette_color[255]);
	  };
	for (int ty=0;ty<=h;ty=ty+2)
	  {
	     putpixel(b,x,y+ty,palette_color[255]);
	     putpixel(b,x+w, y+ty,palette_color[255]);
	  };
     }
   else rect(b,x,y,x+w,y+h,palette_color[255]);
   
   
}






gui_d_shadow_box_proc::gui_d_shadow_box_proc(char* dummy) : dialog(dummy)
{
   name="d_shadow_box_proc";
}
int gui_d_shadow_box_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_shadow_box_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],   key_convert(),    flags_convert(),       d1,  d2,    NULL
     };
   d_shadow_box_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
}





gui_d_box_proc::gui_d_box_proc(char* dummy) : dialog(dummy)
{
   name="d_box_proc";
}
int gui_d_box_proc:: activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_box_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],    key_convert(),    flags_convert(), d1,  d2,    NULL
     };
   d_box_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
}








/*
 * The next class is the base class of all text-dialog objects.
 * These are all dialog objects which contain a data in the dp 
 * field. 
 * The additional member char* s always contains text. For 
 * pure text objects s and dp is the same, but s was necessary 
 * for the textout-function.
 * 
 * */
gui_d_text_proc::gui_d_text_proc( char* text):dialog(text)
{
   dp=text;
   strcpy(s,text);
   TextID=TRUE;
   centre=FALSE;
   name="d_text_proc";
}

void gui_d_text_proc::save_items(int line_nr,String DialogName)
{
   if (TextID==FALSE) fout<<"\nchar "<<dp<<"[256] = \""<<s<<"\";";

}
void gui_d_text_proc::rename(char* text)
{
   dp=dp+text;
   strcpy(s,text);
}
gui_d_text_proc::copy(gui_d_text_proc& from,int& xc, int& yc,int NoDeltaMove=0)
{
   dialog::copy(from,xc,yc,NoDeltaMove);
   strcpy(s,from.s);
   TextID=from.TextID;
}
	
void gui_d_text_proc:: export()
{
   if (TextID==TRUE)
    {
       strcpy(s,dp);
       dp="__dp_POINTS_TO_ASCII__";
    }
   dialog::export();
   fout<<"\n"<<s; /* The s-argument can include spaces */
   if (TextID==TRUE) dp=s;
}
void gui_d_text_proc::import()
{
   dialog::import();
   fin.getline(s,255); /* There is a newlinechar*/
   fin.getline(s,255);
   if (dp=="__dp_POINTS_TO_ASCII__")
      {
       TextID=TRUE;
       dp=s;
       }
   else TextID=FALSE;


}
void gui_d_text_proc::position()
{
   set_mouse_range(X_GUI,Y_GUI,X_GUI+_W,Y_GUI+_H);
   position_mouse(X_GUI,Y_GUI);
   if (WAIT) rest(500);
   while (!(mouse_b & 1));
   x=grid(mouse_x)-X_GUI;
   y=grid(mouse_y)-Y_GUI;
   set_mouse_range(0,0,__W,__H);
}

char* gui_d_text_proc::input()
{
   
   int Text_ID;
   int Iden_ID;
   int EditDefault;
   char id[STRINGLENGTH];
   char id_string[STRINGLENGTH]="";
   strcpy(id,name);
   char input_string[STRINGLENGTH];
   String Temp;
   char dp_[15]="dp (ASCII):";

// Allegro - C- code done with MichisDialogkiste
//                   MDK 3.0b

   if (TextID==TRUE)
      {
         strcpy(s,dp);
         Text_ID=D_SELECTED;
         Iden_ID=D_EXIT;
         strcpy(id_string,"no ID");
         EditDefault=138;
      }
   else
      {  Text_ID=D_EXIT;
         Iden_ID=D_SELECTED;
         EditDefault=100;
         strcpy(id_string,s);
         strcpy(dp_,"dp (char*):");
      }
   strcpy(input_string,dp);

   DIALOG id_dialog[]= {
/* 0 */	{ d_shadow_box_proc ,	124 ,	108 ,	246 ,	126 ,	palette_color[96] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 1 */	{d_text_proc ,	136 ,	120 ,	120 ,	12 ,	palette_color[249] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 name },
/* 2 */	{d_radio_proc ,	136 ,	170 ,	102 ,	12 ,	palette_color[96] ,	palette_color[28] ,	0 ,   Iden_ID ,	1 ,	0 ,	 "dp points to Identifier" },
/* 3 */	{d_radio_proc ,	136 ,	186 ,	102 ,	12 ,	palette_color[96] ,	palette_color[28] ,     0,    Text_ID ,	1 ,	0 ,	 "dp is ASCII-Text" },
/* 4 */	{d_edit_proc ,	226 ,	138 ,	140 ,	12 ,	palette_color[100] ,	palette_color[28] ,	0,	0 ,256 ,	1 ,	 input_string},
/* 5 */	{d_button_proc ,	136 ,	210 ,	66 ,	12 ,	palette_color[96] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "OK" },
/* 6 */	{d_button_proc ,	220 ,	210 ,	66 ,	12 ,	palette_color[96] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "More" },
/* 7 */	{d_button_proc ,	298 ,	210 ,	66 ,	12 ,	palette_color[96] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
/* 8 */	{d_edit_proc ,	196 ,	154 ,	170 ,	12 ,	palette_color[EditDefault] ,	palette_color[28] ,	0,	0 , 256 ,  1 ,	 id_string},
/* 9 */	{d_text_proc ,	136 ,	138 ,	44 ,	12 ,	palette_color[100] ,	palette_color[28] ,	0,	0 ,   0 ,   0 , 	 dp_},
/* 10 */	{d_text_proc ,	136 ,	154 ,	44 ,	12 ,	palette_color[EditDefault] ,	palette_color[28] ,	0,	0 ,   0 ,    0 ,	 "String:"},    { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   centre_dialog(id_dialog);
   do
     {
    	popup_dialog(id_dialog,-1);

     	if (id_dialog[3].flags!=Iden_ID)
         {
     	    if (id_dialog[3].flags==D_SELECTED)
             {
              TextID=FALSE;
              strcpy(id_string,"DefaultText");
              strcpy(dp_,"dp (char*):");
              }
          }
     	if (id_dialog[2].flags!=Text_ID)
         {
     	    if (id_dialog[2].flags==D_SELECTED)
             {

              TextID=TRUE;
              Temp=id_string;
              strcpy(id_string,"no_ID");
              strcpy(dp_,"dp (ASCII):");
              }
          }
      if (TextID==TRUE)
        {
           id_dialog[2].flags=D_EXIT;
           Iden_ID=D_EXIT;
           id_dialog[3].flags=D_SELECTED;
           Text_ID=D_SELECTED;


           id_dialog[8].fg=pallete_color[138];
           id_dialog[10].fg=pallete_color[138];
           dp=input_string;
           strcpy(s,id_string);
        }
      else
      {
           strcpy(s,input_string);
           dp=s;
           id_dialog[2].flags=D_SELECTED;
           Iden_ID=D_SELECTED;
           id_dialog[3].flags=D_EXIT;
           Text_ID=D_EXIT;

           id_dialog[8].fg=pallete_color[100];
           id_dialog[10].fg=pallete_color[96];


       }


	if (id_dialog[6].flags==MSG_DCLICK)
	  show_prop(128,255);
	if (id_dialog[7].flags==MSG_DCLICK) this->help();

     } while (id_dialog[5].flags!=MSG_DCLICK);

     if (TextID==TRUE)
        {
         TextID=FALSE;
         dp=input_string;
         strcpy(s,Temp);
        }
      else
         {
         TextID=TRUE;
         dp=input_string;
         strcpy(s,input_string);
 
          }

   return input_string;
	     
	     
}
int gui_d_text_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   if (TextID==TRUE) strcpy(s,dp);
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_text_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],    key_convert(),    flags_convert(),  d1,  d2,    s
     };
   d_text_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
}

int gui_d_text_proc::save(int line_nr)
{
   fout<<"\n";
   if (WRITE_COLORS_STATIC!=D_SELECTED)
    {
      if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
      fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\t"<<fg;
      fout<<",\t"<<bg<<",\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
      fout<<" ,\t";
      if (TextID==TRUE) fout<<" \""<<dp<<"\" },";
        else fout<<" "<<dp<<" },";

    }
    else
    {
      if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
      fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\tpalette_color["<<fg;
      fout<<"],\tpalette_color["<<bg<<"],\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
      fout<<" ,\t";
      if (TextID==TRUE) fout<<" \""<<dp<<"\" },";
        else fout<<" "<<dp<<" },";

      }

}






gui_d_ctext_proc::gui_d_ctext_proc( char* text):gui_d_text_proc(text)
{
   centre=TRUE;
   name="d_ctext_proc";
   
}

int gui_d_ctext_proc:: activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   if (TextID==TRUE) strcpy(s,dp);
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_ctext_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],    key_convert(),    flags_convert(),  d1,  d2,    s
     };
   d_text_proc(MSG_DRAW,this_dia,0);
   screen=Screen;

}


gui_d_textbox_proc::gui_d_textbox_proc( char* text):gui_d_text_proc(text)
{
   centre=FALSE;
   TextID=FALSE;
   name="d_textbox_proc";
   
}

int gui_d_textbox_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   if (TextID==TRUE) strcpy(s,dp);
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_textbox_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],    key_convert(),    flags_convert(),  d1,  d2,    s
     };
   d_textbox_proc(MSG_DRAW,this_dia,0);
  screen=Screen;

}





gui_d_edit_proc::gui_d_edit_proc( char* pointer):gui_d_text_proc(pointer)
{
   centre=FALSE;
   TextID=FALSE;
   name="d_edit_proc";
   dp=String(pointer);
   strcpy(s,"INPUT");
   d2=1;
   d1=256;

}
void gui_d_edit_proc::export()
{
   dialog::export();
   fout<<"\n"<<s; /* The s-argument can include spaces */
}
void gui_d_edit_proc::import()
{
   dialog::import();
   fin.getline(s,255); /* There is a newlinechar*/
   fin.getline (s,255);
}
void gui_d_edit_proc::rename(char* text)
{
  /* do not do anything */
}
void gui_d_edit_proc::default_string(char* zu)
{
   strcpy(s,zu);
   activate_func();
}
void gui_d_edit_proc::save_string()
{
   fout<<"\nchar "<<dp<<"["<<d1<<"]=\""<<s<<"\" ;\n";
};
void gui_d_edit_proc::save(int line_nr)
{
   dialog::save(line_nr);
}
char* gui_d_edit_proc::input()
{
   // Allegro - C- code done with MichisDialogkiste 
   char d1_feld[3];
   itoa(d1,d1_feld,10);
   char d2_feld[3];
   itoa(d2,d2_feld,10);
   char id[STRINGLENGTH];
   strcpy(id,name);
   char input_string[STRINGLENGTH];
   strcpy(input_string,dp);
   
   DIALOG id_dialog[]= {
	{ d_shadow_box_proc ,    208 ,   288 ,   216 ,   120 ,   palette_color[5],    palette_color[28] ,    0 ,     0 ,     0 ,     0 ,     NULL},
	{ d_text_proc ,  220 ,   300 ,   144 ,   24 ,    palette_color[136] ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,      id },
	{ d_text_proc ,  220 ,   312 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[IDENTIFIER_]},
	{ d_text_proc ,  220 ,   336 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[DEFAULT_TEXT_] },
	{ d_text_proc ,  220 ,   360 ,   120 ,   12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[STARTPOSITION_D2_] },
	{ d_text_proc ,  220 ,   372 ,   120 ,   12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[MAXIMUM_NO_OF_CHARS_] },
	{ d_button_proc ,        220 ,   384 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
	{ d_button_proc ,        364 ,   384 ,   48 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
	{ d_button_proc ,        292 ,   384 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[MORE_] },
	{ d_edit_proc ,  220 ,   324 ,   160 ,   12 ,    palette_color[15] ,    palette_color[28],    0 ,     0 ,     28 ,    1 ,     input_string},
      { d_edit_proc ,  220 ,   348 ,   160 ,   12 ,    palette_color[15] ,   palette_color[28],    0 ,     0 ,     28 ,    1 ,     s},
	{ d_edit_proc ,  370 ,   360 ,   40 ,    12 ,    palette_color[15] ,   palette_color[28],    0 ,     0 ,     4 ,     1 ,     d2_feld},
	{ d_edit_proc ,  370 ,   372 ,   40 ,    12 ,    palette_color[15] ,   palette_color[28],    0 ,     0 ,     4 ,     1 ,     d1_feld},
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   do
     {
	do_dialog(id_dialog,-1);
	dp=input_string;
	
	d1=atoi(d1_feld);
	d2=atoi(d2_feld);
	
	if (id_dialog[8].flags==MSG_DCLICK)
	  show_prop(128,255);
	if (id_dialog[7].flags==MSG_DCLICK)
	  help();
     }
   while (id_dialog[6].flags!=MSG_DCLICK);
   
   return input_string;
   
   
}
   
   


gui_d_button_proc::gui_d_button_proc( char* text):gui_d_text_proc(text)
{
   centre=TRUE;
   flags="D_EXIT";
   name="d_button_proc";
}
int gui_d_button_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   strcpy(s,dp);
   DIALOG this_dia[]=
     {
	d_button_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],  key_convert(), flags_convert(),       d1,  d2,    s
     };
   d_button_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
   
}
void gui_d_button_proc::write_defines(String DialogName,int DialogID)
{
   String dp_save;
   dp_save=dp;
   dp_save.gsub(" ","_");
   dp_save.gsub("&","_");
   dp_save.gsub("+","_");
   dp_save.gsub("-","_");
   dp_save.gsub("*","_");
   dp_save.gsub("/","_");
   dp_save.gsub("?","_");
   dp_save.gsub("(","_");
   dp_save.gsub("\"","_");
   dp_save.gsub(")","_");
   dp_save.gsub("{","_");
   dp_save.gsub("}","_");

   fout<<"\n#define _"<< upcase(DialogName)<<"_"<< upcase(dp_save)<<" "<<DialogID;
}
void gui_d_button_proc::save(int line_nr)
{
   gui_d_text_proc::save(line_nr);
}






gui_d_radio_proc::gui_d_radio_proc( char* text):gui_d_text_proc(text)
{
   centre=FALSE;
   flags="0";
   name="d_radio_proc";
}
int gui_d_radio_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   strcpy(s,dp);
   DIALOG this_dia[]=
     {
	d_radio_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],  key_convert(), flags_convert(),       d1,  d2,    s
     };
   d_radio_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
}
char* gui_d_radio_proc::input()
{
   // Allegro - C- code done with MichisDialogkiste 
   char d1f[25]="0" ;
   char Button[25];
   strcpy(Button,dp);
   DIALOG id_dialog[]= {
	{ d_shadow_box_proc ,  168 ,   96 ,    192 ,   132 ,   palette_color[96],   palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},
	{ d_text_proc ,        180 ,   108 ,   120 ,   12 ,    palette_color[249] ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,      "Radio-Button" },
	{ d_text_proc ,        180 ,   132 ,   84 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     0 ,     0 ,     0 ,       UserText[GROUP_D1_] },
	{ d_text_proc ,        180 ,   168 ,   84 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     0 ,     0 ,     0 ,       UserText[BUTTON_TEXT_] },
	{ d_button_proc ,      180 ,   204 ,   48 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
	{ d_button_proc ,      240 ,   204 ,   48 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[MORE_] },
	{ d_button_proc ,      300 ,   204 ,   48 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
	{ d_radio_proc ,       180 ,   144 ,   96 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     D_SELECTED ,    0 ,     0 ,  UserText[CIRCLE_]},
	{ d_radio_proc ,       264 ,   144 ,   72 ,    12 ,    palette_color[96],   palette_color[28],    0 ,     0 ,     0 ,     1 ,        UserText[RECT_] },
	{ d_edit_proc ,        276 ,   132 ,   48 ,    12 ,    palette_color[100] ,  palette_color[28],    0 ,     0 ,     8 ,     1 ,     d1f},
	{ d_edit_proc ,        180 ,   180 ,   144 ,   12 ,    palette_color[100] ,  palette_color[28],    0 ,     0 ,     28 ,    1,      Button},
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   
   do
     {
	do_dialog(id_dialog,-1);
	strcpy(s,Button);
	dp=Button;
	if (id_dialog[6].flags==MSG_DCLICK)
	  help();
	d1=atoi(d1f);
	d2=0;
	if (id_dialog[8].flags==2) d2=1;
	
	
		  if (id_dialog[5].flags==MSG_DCLICK)
              	  show_prop(128,255);
	
	       } while (id_dialog[4].flags!=MSG_DCLICK);
   
   return Button;
   
}

void gui_d_radio_proc::write_defines(String DialogName,int DialogID)
{
   String dp_save;
   dp_save=dp;
   dp_save.gsub(" ","_");
   dp_save.gsub("&","_");
   dp_save.gsub("+","_");
   dp_save.gsub("-","_");
   dp_save.gsub("*","_");
   dp_save.gsub("/","_");
   dp_save.gsub("?","_");
   dp_save.gsub("(","_");
   dp_save.gsub("\"","_");
   dp_save.gsub(")","_");
   dp_save.gsub("{","_");
   dp_save.gsub("}","_");

   fout<<"\n#define _"<< upcase(DialogName)<<"_"<<upcase(dp_save)<<" "<<DialogID;
}
void gui_d_radio_proc::save(int line_nr)
{
   gui_d_text_proc::save(line_nr);
}







gui_d_check_button_proc::gui_d_check_button_proc( char* text):gui_d_text_proc(text)
{
   name="d_check_proc";
}
int gui_d_check_button_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   strcpy(s,dp);
   DIALOG this_dia[]=
     {
	d_check_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],  key_convert(),flags_convert(),       d1,  d2,    s
     };
   d_check_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
   
}
void gui_d_check_button_proc::write_defines(String DialogName,int DialogID)
{
   String dp_save;
   dp_save=dp;
   dp_save.gsub(" ","_");
   dp_save.gsub("&","_");
   dp_save.gsub("+","_");
   dp_save.gsub("-","_");
   dp_save.gsub("*","_");
   dp_save.gsub("/","_");
   dp_save.gsub("?","_");
   dp_save.gsub("(","_");
   dp_save.gsub("\"","_");
   dp_save.gsub(")","_");
   dp_save.gsub("{","_");
   dp_save.gsub("}","_");
   fout<<"\n#define _"<< upcase(DialogName)<<"_"<<upcase(dp_save)<<" "<<DialogID;
}









char* gui_d_listbox_proc::data(int index)
{
   if ((index < 0)&&(index>mxs)) return NULL;
   else 
     {
	char s[STRINGLENGTH];
	int len=0;
	strcpy(s,temps[index]);
	while (s[len]!=NULL) len++;
	while (text_length(font,(unsigned char*) s) >w)
	  {
	     s[len]=NULL;
	     len--;
	  }
	return s;
     }
}
gui_d_listbox_proc::gui_d_listbox_proc( char* text):gui_d_text_proc(text)
{
   name="d_list_proc";
   mxs=list_size;
   size=0;
   temps=new String[mxs] ("**EMPTY**");
}
gui_d_listbox_proc::~gui_d_listbox_proc()
{
   delete[] temps;
}
void gui_d_listbox_proc::save_items(int line_nr,String DialogName)
{
   if (size>0)
     {
	fout<<"\nchar* "<<dp<<" (int index, int* list_size) { \n";
	fout<<"    static char* strings[]={";
	for (int t=0;t<size-1;t++) fout<<"\""<<temps[t]<<"\" , ";
	
	fout <<"\""<<temps[size-1]<<"\" };\n";
	fout<<"if (index < 0) \n\t { *list_size ="<<size<<";\n";
	fout<<"\t   return NULL;}";
	fout<<"\n else return strings[index];}\n\n";
     }
}

void gui_d_listbox_proc::export()
{
   dialog::export();
   fout<<size;
   for (int t=0;t<size;t++)
     fout<<"\t"<<temps[t];
   fout<<"\n";
   
};
void gui_d_listbox_proc::import()
{
   dialog::import();
   fin>>size;
   for (int t=0;t<size;t++)
     fin>>temps[t];
   strcpy(s,dp);
}
void gui_d_listbox_proc::copy(gui_d_listbox_proc& from,int& xc, int& yc,int NoDeltaMove=0)
{
   dialog::copy(from, xc, yc,NoDeltaMove);
   for (int t=0;t<from.size;t++)
     temps[t]=from.temps[t];
   size=from.size;
}

char* gui_d_listbox_proc::input ()
{
   int dial;
   int list_selector=size;
   
   char list_name[STRINGLENGTH];
   strcpy(list_name,dp);
   for (int t=0;t<mxs;t++)
     strcpy(listobjects[t],temps[t]);
   
   DIALOG id_dialog[]= {
	{ d_shadow_box_proc , 148 ,   180 ,   216 ,   216 ,   187 ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},
	{ d_text_proc ,       160 ,   192 ,   156 ,   12 ,    16 ,   palette_color[28],    0 ,     0 ,     0 ,     0 ,      "ListBox" },
	{ d_text_proc ,       160 ,   216 ,   108 ,   12 ,    187 ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[LIST_FUNCTION_] },
	{ d_text_proc ,       160 ,   252 ,   180 ,   12 ,    187 ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[OBJECTS_IN_LIST_] },
	{ d_text_proc ,       160 ,   348 ,   180 ,   12 ,    187 ,  palette_color[28],    0 ,     0 ,     0 ,     0 ,      UserText[DOUBLE_CLICK_ON_LIST_] },
	{ d_button_proc ,     160 ,   372 ,   48 ,    12 ,    187 ,  palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
	{ d_button_proc ,     220 ,   372 ,   60 ,    12 ,    187 ,  palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[MORE_]},
	{ d_button_proc ,     292 ,   372 ,   60 ,    12 ,    187 ,  palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[HELP_] },
	{ d_edit_proc ,       160 ,   228 ,   156 ,   12 ,    200 ,  palette_color[28],    0 ,     0 ,     1 ,     8 ,     list_name},
	{ d_list_proc ,       160 ,   276 ,   192 ,   60 ,    187 ,  palette_color[28],    0 ,     D_EXIT ,        list_selector , 0 ,     Liste5},
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   
   do{
      for (int t=0;t<mxs;t++)
	strcpy(listobjects[t],temps[t]);
      centre_dialog(id_dialog);
      popup_dialog(id_dialog,-1);
      dial=id_dialog[5].flags;
      
      if (id_dialog[6].flags==MSG_DCLICK)
	show_prop(128,255);
      
      if (id_dialog[7].flags==MSG_DCLICK)
	help();
      
      if (id_dialog[9].flags==MSG_DCLICK)
	{
	   
	   list_selector=id_dialog[9].d1;
	   char temp_char[STRINGLENGTH]="None";
	   String helper_string;
	   if (list_selector>size) list_selector=size;
	   DIALOG item_dialog[]= {
		{ d_shadow_box_proc , 208 ,   348 ,   216 ,   60 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,     NULL},
		{ d_text_proc ,       220 ,   360 ,   96 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     0 ,     0 ,     0 ,       UserText[EDIT_ITEM_]},
		{ d_button_proc ,     220 ,   384 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,      UserText[OK_] },
		{ d_button_proc ,     352 ,   384 ,   60 ,    12 ,    palette_color[5],    palette_color[28],    0 ,     D_EXIT ,        0 ,     0 ,   UserText[DELETE_]},
		{ d_edit_proc ,       220 ,   372 ,   150 ,   12 ,    palette_color[12] ,   palette_color[28],    0 ,     0 ,     STRINGLENGTH ,  1 ,   temp_char},
		{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	   };
         centre_dialog(item_dialog);
	   popup_dialog(item_dialog,-1);
	   if (item_dialog[3].flags==MSG_DCLICK)
	     {
		if (size) size--;
		temps[size]="";
	     }
	   else
	     {
		temps[list_selector]=temp_char;
		if (list_selector==size)  size++;
	     }
	   
	}
      
      
   }
   while (dial!=MSG_DCLICK);
   
  return "List_Done";
   
}
int gui_d_listbox_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   int lsize=list_size;
   list_size=size;
   for (int t=0;t<mxs;t++)
     strcpy(listobjects[t],temps[t]);
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_list_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],  key_convert(),flags_convert(),       d1,  d2,   Liste5
     };
   d_list_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
   list_size=lsize;
}
void gui_d_listbox_proc::write_defines(String DialogName,int DialogID)
{
   String dp_save;
   dp_save=dp;
   dp_save.gsub(" ","_");
   dp_save.gsub("&","_");
   dp_save.gsub("+","_");
   dp_save.gsub("-","_");
   dp_save.gsub("*","_");
   dp_save.gsub("/","_");
   dp_save.gsub("?","_");
   dp_save.gsub("(","_");
   dp_save.gsub("\"","_");
   dp_save.gsub(")","_");
   dp_save.gsub("{","_");
   dp_save.gsub("}","_");
   fout<<"\n#define _"<< upcase(DialogName)<<"_"<<upcase(dp_save)<<" "<<DialogID;
}
void gui_d_listbox_proc::save(int line_nr)
{
   dialog::save(line_nr);
}







void gui_d_keyboard_proc::copy(gui_d_keyboard_proc &from)
{
  int dummy;
  dialog::copy(from,dummy,dummy);
  ASCII=D_SELECTED;
  d1_ID=from.d1_ID;
  d2_ID=from.d2_ID;
  CTRL_key=from.CTRL_key;
  d1_key1=from.d1_key1;
  d2_key1=from.d2_key1;
  d1_key2=from.d1_key2;
  d2_key2=from.d2_key2;
}


gui_d_keyboard_proc::gui_d_keyboard_proc(char* text,String keyt):gui_d_text_proc(text)
{
   key="\'k\'";
   name="d_keyboard_proc";
   ASCII=D_SELECTED;
   d1_ID="KEY_?";
   d2_ID="KEY_?";
   CTRL_key=FALSE;
   d1_key1=FALSE;
   d2_key1=FALSE;
   d1_key2=FALSE;
   d2_key2=FALSE;
   dp="func?";
 };

int gui_d_keyboard_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0){};
char* gui_d_keyboard_proc::input()
{
   int Scan=0;
   // Allegro - C- code done with MichisDialogkiste
   //                   MDK 3.0b
#define _k_SELECT_VIA_ASCII_CTRL 6
#define _k_ENTER_SCANCODE 8
#define _k_CTRL 3
#define _k_D1 13
#define _k_D2 14
#define _k_D22 15
#define _k_D21 16
#define _k_OK 18
#define _k_HELP 19
   char key_ASCII[3];
   char Scancode[256];
   char dp_field[256];
    char Scancode2[256];
   if (ASCII==D_SELECTED)
     {
	
	if (CTRL_key!=D_SELECTED) key=key[1];
	else
	  {
           int dummy2=atoi(key);
           key=char(dummy2+'A'-1);
        }
     } else Scan=D_SELECTED;
   strcpy(dp_field,dp);
   strcpy(key_ASCII,key);
   strcpy(Scancode,d1_ID);
   strcpy(Scancode2,d2_ID);
   
   DIALOG k_dialog[]= {
      /* 0 */	{ d_shadow_box_proc ,	106 ,	90 ,	306 ,	180 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 1 */	{d_text_proc ,	112 ,	96 ,	126 ,	12 ,	palette_color[249] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Shortcut" },
      /* 2 */	{ d_box_proc ,	112 ,	114 ,	96 ,	30 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 3 */	{d_check_proc ,	152 ,	125 ,	60 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	CTRL_key,	0 ,	0 ,	 "CTRL" },
      /* 4 */	{ d_edit_proc ,	118 ,	126 ,	20 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	2 ,	1 ,	key_ASCII},
      /* 5 */	{d_text_proc ,	136 ,	126 ,	48 ,	24 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "+" },
      /* 6 */	{d_radio_proc ,	215 ,	124 ,	162 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	ASCII ,	0 ,	0 ,	 "Select via ASCII/CTRL" },
      /* 7 */	{ d_box_proc ,	112 ,	162 ,	96 ,	30 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 8 */	{d_radio_proc ,	216 ,	147 ,	162 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	Scan ,	0 ,	0 ,	 "Enter Scancode" },
      /* 9 */	{ d_edit_proc ,	118 ,	174 ,	90 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	Scancode},
      /* 10 */	{d_text_proc ,	118 ,	252 ,	144 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "function (dp):" },
      /* 11 */	{ d_edit_proc ,	238 ,	252 ,	168 ,	12 ,	palette_color[164] ,	palette_color[28] ,	0 ,	0 ,	256 ,	1 ,	dp_field},
      /* 12 */	{ d_box_proc ,	112 ,	204 ,	96 ,	30 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 13 */	{d_check_proc ,	232 ,	174 ,	36 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	d1_key1 ,	0 ,	0 ,	 "d1" },
      /* 14 */	{d_check_proc ,	274 ,	174 ,	36 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	d2_key1 ,	0 ,	0 ,	 "d2" },
      /* 15 */	{d_check_proc ,	274 ,	216 ,	36 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	d2_key2 ,	0 ,	0 ,	 "d2" },
      /* 16 */	{d_check_proc ,	232 ,	216 ,	36 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	d1_key2 ,	0 ,	0 ,	 "d1" },
      /* 17 */	{d_edit_proc ,	118 ,	216 ,	90 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	Scancode2},
      /* 18 */	{d_button_proc ,	352 ,	198 ,	48 ,	12 ,	palette_color[100] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
      /* 19 */	{d_button_proc ,	352 ,	216,	48 ,	12 ,	palette_color[100] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   
   
   centre_dialog(k_dialog);
   do{
   popup_dialog(k_dialog,-1);
   if (k_dialog[_k_HELP].flags==MSG_DCLICK) help();
   ASCII=k_dialog[_k_SELECT_VIA_ASCII_CTRL].flags;
   CTRL_key=k_dialog[_k_CTRL].flags;
   d1_key1=k_dialog[_k_D1].flags;
   d2_key1=k_dialog[_k_D2].flags;
   d1_key2=k_dialog[_k_D21].flags;
   d2_key2=k_dialog[_k_D22].flags;
   dp=dp_field;

   if (k_dialog[_k_SELECT_VIA_ASCII_CTRL].flags==D_SELECTED)
     {
	
	if (k_dialog[_k_CTRL].flags==D_SELECTED)
	  {
	     strupr(key_ASCII);
	     char dummy[20];
	     key=itoa(key_ASCII[0]-'A'+1,dummy,10);
	     CTRL_key;
	  }
	     else
	  {
	     String esc="\'";
	     key=esc+key_ASCII+esc;
	  }
	
     } else
     {
        d1_ID=Scancode;
        d2_ID=Scancode2;
        }
      } while (k_dialog[_k_OK].flags!=MSG_DCLICK);
   return dp_field;
   
};
void gui_d_keyboard_proc::export()
{
   dialog::export();
   fout<<"\t"<<ASCII<<"\t"<<d1_ID<<"\t"<<d2_ID<<"\t"<<CTRL_key<<"\t";
   fout<<d1_key1<<"\t"<<d1_key2<<"\t"<<d2_key1<<"\t"<<d2_key2<<"\t";
}
String gui_d_keyboard_proc::import()
{
   dialog::import();
   fin>>ASCII>>d1_ID>>d2_ID>>CTRL_key;
   fin>>d1_key1>>d1_key2>>d2_key1>>d2_key2;
   return dp;
}

void gui_d_keyboard_proc::save(int line_nr)
{
   fout<<"\n";
   if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
   fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\t"<<fg;
   fout<<",\t"<<bg<<",\t";
   if (ASCII) fout<<key<<" ,\t"; else fout<<"0 ,\t";
   fout<<flags<<" ,\t";

   if ((d1_key1==D_SELECTED)&(d2_key1==D_SELECTED)) fout <<d1_ID<<" & "<<d2_ID<<",\t";
   else
    {
     if (d1_key1==D_SELECTED) fout <<d1_ID<<",\t";
     if (d2_key1==D_SELECTED) fout <<d2_ID<<",\t";
     if ((d1_key1!=D_SELECTED)&(d2_key1!=D_SELECTED)) fout<<d1<<",\t";
     };

   if ((d1_key2==D_SELECTED)&(d2_key2==D_SELECTED)) fout <<d1_ID<<" & "<<d2_ID<<",\t";
   else
    {
     if (d1_key2==D_SELECTED) fout <<d1_ID<<",\t";
     if (d2_key2==D_SELECTED) fout <<d2_ID<<",\t";
     if ((d1_key2!=D_SELECTED)&(d2_key2!=D_SELECTED)) fout<<d2<<",\t";
     };

   fout<<dp<<"},";
 }








MainMenu::MainMenu(String pointer):dialog("DUMMY" )
{
	name="d_menu_proc";
	dp=pointer;
     }
   
int MainMenu::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0){}
   
   
   
void dialog::help()
{
 set_object_help_dialog();
 do_help();
 };
void gui_d_keyboard_proc::help()
{
  set_object_help_keyboard();
  do_help();
 }
void gui_d_clear_proc::help()
{
 set_object_help_clear();
  do_help();
   }
void gui_d_box_proc::help()
 {
  set_object_help_box();
   do_help();
  }
void gui_d_shadow_box_proc::help()
 {
  set_object_help_shadow();
  do_help();
  }


void gui_d_text_proc::help()
 {
  set_object_help_text();
   do_help();
  };

void gui_d_ctext_proc::help()
 {
  set_object_help_ctext();
  do_help();
 }

void gui_d_button_proc::help()
 {
  set_object_help_button();
  do_help();
 }


void gui_d_edit_proc::help()
 {
   set_object_help_edit();
   do_help();
 }

void gui_d_check_button_proc::help()
 {
  set_object_help_check();
  do_help();
  }

void gui_d_listbox_proc::help()
{
 set_object_help_list();
  do_help();
 }

void gui_d_radio_proc::help()
 {
  set_object_help_radio();
  do_help();
 }              
void gui_d_textbox_proc::help()
 {
   set_object_help_textbox();
   do_help();
 }
   
