#include <stdio.h>
#include "m3d.h"

static void _m3d_ExportVTX(obj *o, FILE *out)
{
    int x, y;

    if (o->nfaces > 0) {
        /* output verteces */
        fprintf(out, ".Vertex\n");
        for (x = 0; x < o->nfaces; x++)
            for (y = 0; y < 3; y++)
                fprintf(out, "%f %f %f 0 0 0 %f %f\n", o->faces[x].v[y].x, o->faces[x].v[y].y, o->faces[x].v[y].z, (float)o->faces[x].v[y].u / (float)(1<<16), (float)o->faces[x].v[y].v / (float)(1<<16));

        /* output faces */
        fprintf(out, "\n\n.Index\n");
        for (x = 0; x < o->nfaces; x++)
            fprintf(out, "%d %d %d -1\n", 3*x+0, 3*x+1, 3*x+2);

        /* color */
        fprintf(out, "\n\n.Brdf\n1 1 1\n\n\n");
    }
    for (x = 0; x < o->nchild; x++)
        _m3d_ExportVTX(&o->child[x], out);
}

void m3d_ExportVTX(obj *o, char *name)
{
    FILE *out;
    int x;

    out = fopen(name, "w");
    _m3d_ExportVTX(o, out);
    fclose(out);
}
