//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"
#include <ctype.h>

//----------------------------------------------------------------------------
// Wrapper for MENU struct
//----------------------------------------------------------------------------
// Constructor
menu::menu (void)
	:internal(NULL),
	number(0)
   {
   }
//----------------------------------------------------------------------------
// Destructor
menu::~menu (void)
   {
   delete [] internal;
   }
//----------------------------------------------------------------------------
// Add something to the menu
void menu::_add (const char *text, int(*proc)(void), const MENU *child)
	{
	// Make space for the new stuff
   MENU* new_internal = new MENU[number+2];
   if(new_internal==NULL) degui_no_memory();

	// Copy the old stuff over
	for(int i=0;i<number;i++) new_internal[i] = internal[i];

	// Add the new object
	new_internal[number].text = (char*)text;
	new_internal[number].proc = (int(*)(...))proc;
  	new_internal[number].child = (MENU*)child;

	// Make sure that there is a correct last NULL at the end
	new_internal[number+1].text = NULL;
	new_internal[number+1].proc = NULL;
  	new_internal[number+1].child = NULL;

	// Delete the old stuff
	if(internal!=NULL) delete [] internal;

	// Exchange the pointer sets
	internal = new_internal;
   number++;
	}
//----------------------------------------------------------------------------
// Add a child menu
void menu::add (const char *text, const menu &child)
	{
   _add(text,NULL,child.internal);
	}
//----------------------------------------------------------------------------
// Add a procedure
void menu::add (const char *text, int(*proc)(void))
	{
   _add(text,proc,NULL);
	}
//----------------------------------------------------------------------------
// Menu object
//----------------------------------------------------------------------------
// Constructor
menu_object::menu_object (const menu& men)
   :internal(men.internal)
   {
   // Setup the defaults
   set_x(0);
   set_y(0);
   set_h(0);
   set_w(0);
   }
//----------------------------------------------------------------------------
// Destructor
menu_object::~menu_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

void menu_object::msg_start (void)
	{
   MENU_INFO m;

   _fill_menu_info(&m, internal, NULL, TRUE, x()-1, y()-1);
   set_w(m.w-2);
   set_h(m.h-2);
   }
//----------------------------------------------------------------------------
void menu_object::msg_draw (void)
   {
   MENU_INFO m;

   _fill_menu_info(&m, internal, NULL, TRUE, x()-1, y()-1);
   _draw_menu(&m);
   _redraw = false;
   }
//----------------------------------------------------------------------------
bool menu_object::msg_xchar (const int c)
   {
   int x = _menu_alt_key(c, internal);
   if (!x) return false;

   simulate_keypress(x);
   msg_click();

   return true;
   }
//----------------------------------------------------------------------------
void menu_object::msg_click (void)
   {
   int xx = 0;
   _do_degui_menu(internal, NULL, TRUE, x()-1, y()-1, FALSE, &xx);
   do {
      } while (mouse_b);
   }
//----------------------------------------------------------------------------

