//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"
#include <ctype.h>
#include <string.h>

//----------------------------------------------------------------------------
// Simple object to clear the screen and put up a grid
//----------------------------------------------------------------------------
// Constructor
grid_object::grid_object (const int xg, const int yg)
   :x_gran(xg),
   y_gran(yg)
   {
   // Setup the defaults
   set_x(0);
   set_y(0);
	set_w(0);
   set_h(0);
   }
//----------------------------------------------------------------------------
// Destructor
grid_object::~grid_object (void)
   {
   }
//----------------------------------------------------------------------------
// Basic message passing functions

// Draw the grid object
void grid_object::msg_draw (void)
	{
   // Crear the screen
   set_clip(screen, 0, 0, SCREEN_W-1, SCREEN_H-1);
   clear_to_color(screen, color ? color->back() : degui_back_color);

   int x_step = x_gran;
   int y_step = y_gran;

   // Make sure that there is a reasonable grid size
   if((x_step<2)&&(y_step<2)) return;

   // And draw the grid
   int x = 0, y = 0;
   while(x<SCREEN_W)
      {
      while(y<SCREEN_H)
         {
         putpixel(screen,x,y,color ? color->fore() : degui_fore_color);
         y += y_step;
         }
      x+= x_step;
      y = 0;
      }
   _redraw = false;
	}
//----------------------------------------------------------------------------

