//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Global helper functions for checkboxes
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Draw the checkbox in a degui style
void _draw_checkbox_object (const char *text,
                            const int x, const int y, const int h,
                            const int selected,
                            const int disabled, const int has_focus,
                            const int fore, const int back,
                            const int select, const int deselect,
                            const int disable,
                            const int light_shad, const int dark_shad)
   {
   int y2;
   int boxsize;
   int box_x1;
   int box_y1;
   int box_x2;
   int box_y2;
   int txtlen;
   int text_x;
   int text_y;

   int c_inside = deselect;
   int fg = fore;

   y2 = y+h-1;
   boxsize = text_height(font);
   if(boxsize<12) boxsize = 12;
   box_x1  = x+4;
   box_y1  = (y+y2+1)/2-boxsize/2;
   box_x2  = box_x1+boxsize;
   box_y2  = box_y1+boxsize-1;
   txtlen  = degui_strlen((char*)text);
   text_x  = (box_x2+4);
   text_y  = (y+y2+1)/2-text_height(font)/2;

   // Should the checkbox displayed highlighted or disabled
   if(selected) c_inside = select;
   if(disabled) fg = disable;

   // Draw the checkbox...
   draw_3d_frame(screen,box_x1,box_y1,box_x2,box_y2,c_inside,dark_shad,light_shad);
   text_mode(back);
   degui_textout(screen,(char*)text,text_x,text_y,fg,0);

   // Checked?
   if(selected)
      {
      line(screen,box_x1+4,box_y1+3,box_x2-3,box_y2-3,fg);
      line(screen,box_x2-3,box_y1+3,box_x1+4,box_y2-3,fg);
      line(screen,box_x2-4,box_y1+3,box_x1+3,box_y2-3,fg);
      line(screen,box_x1+3,box_y1+3,box_x2-4,box_y2-3,fg);
      }

   // Display focus frame?
   if(has_focus) draw_dotted_rect(screen,text_x-2,text_y-2,text_x+txtlen+1,text_y+text_height(font)+1,fg);
   else rect(screen,text_x-2,text_y-2,text_x+txtlen+1,text_y+text_height(font)+1,back);
   }
//----------------------------------------------------------------------------

