indexing
    description    : "24 bit rgb colour objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    names          : rgb24bit
    date_started   : "17th December, 1996"
    version        : "0.1"


class RGB24BIT


inherit
    RGB
        rename   make as rgb_make
        redefine make
    end  -- inherit RGB


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make(r, g, b : INTEGER) is
    -- Create a new rgb colour with the specified components
    require else
        red_is_valid   : r <= 255
        green_is_valid : g <= 255
        blue_is_valid  : b <= 255
    do
        rgb_make(r,g,b)
    end  -- feature make


------------------------------------------------------ Class invariant
invariant

    red_is_valid   : red   <= 255
    green_is_valid : green <= 255
    blue_is_valid  : blue  <= 255


end  -- class RGB24BIT


