indexing
    description    : "Allegro con Eiffel: test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : ace_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class ACE_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    local
        default_graphics_palette      : PALETTE
        fade_palette                  : PALETTE
        mode_set_success              : BOOLEAN
        i                             : INTEGER
        x, y                          : INTEGER
        current_x, current_y          : INTEGER
        box_width, box_height         : INTEGER
        std_rand                      : MIN_STAND
        x1, y1, x2, y2                : INTEGER
        colour_index                  : INTEGER
        bitmap, black_bitmap          : BITMAP
        dirty_rectangle               : BITMAP
        visible_screen                : BITMAP
        load_bitmap                   : BITMAP
        save_load_palette             : PALETTE
        angle, value                  : FIXED
        start, stop                   : INTEGER
        duration                      : DOUBLE
        led_zep_datafile              : DATAFILE
        led_zep_bitmap                : BITMAP
        led_zep_palette               : PALETTE
        small_font                    : FONT
        minuet_in_g                   : MIDI
        itchy_and_scratchy            : SAMPLE
        allegro                       : FLIC
        p                             : POINTER
    do
        -- Print out free memory
        c_inline_c("_p=(_go32_dpmi_meminfo *)malloc(sizeof(_go32_dpmi_meminfo));")

        if p.is_void then
            crash_with_message("Could not allocate memory!!")
        end  -- if

        c_inline_c("_go32_dpmi_get_free_memory_information(_p);")
        c_inline_c("printf(%"ace_test start: %%U memory free\n%",((_go32_dpmi_meminfo *)_p)->available_memory);")


--------------------------------------------------- ACE initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("ACE initialisation error: ")
        end  -- if


--------------------------------------------------- Start a timer to see how long everything takes

        -- Initialise the timer
        if not timer.init_success then
            crash_with_message("Timer initialisation failed.")
        end  -- if

        timer.start(10)       -- 100 ticks per second
        start := timer.count


--------------------------------------------------- ACE information

        -- Retrieve the id of ACE
        io.put_character('%N')
        io.put_string(info.id)

        -- Retrieve the id of Allegro
        io.put_character('%N')
        io.put_string(info.allegro_id)

        -- Retrieve the windows version
        io.put_string("%NWindows version: ")
        io.put_integer(info.windows_version)
        io.put_character('.')
        io.put_integer(info.windows_sub_version)

        -- Retrieve the last Allegro error
        io.put_string("%NLast Allegro error: ")
        io.put_string(info.error_description)


--------------------------------------------------- Set a graphics mode

        -- Set a graphics mode
        wait_for_key("%NAbout to set 320x200x256 Mode 13h...")
        mode_set_success := screen.auto_init(320, 200, 0, 0)

        -- Check for mode set success
        if not mode_set_success then
            crash_with_message("Mode set failed: ")
        end  -- if


--------------------------------------------------- Palette manipulation

        -- Retrieve the default graphics palette
        !!default_graphics_palette.make
        default_graphics_palette.get

        -- Make the fade palette black
        !!fade_palette.make
        fade_palette.set_to_black

        -- Set the palette to black
        fade_palette.put

        -- Calculate some stuff up-front for efficiency
        box_width  := screen.visible_width // 16
        box_height := screen.visible_height // 16

        -- Draw boxes with all colours
        from
            y := 0
        invariant
            0 <= y and y <= 16
        variant
            16 - y
        until
            y = 16
        loop
            from
                x := 0
            invariant
                0 <= x and x <= 16
            variant
                16 - x
            until
                x = 16
            loop
                current_x := x * box_width
                current_y := y * box_height
                screen.filled_rectangle(current_x,
                                        current_y,
                                        current_x+box_width,
                                        current_y+box_height,
                                        y*16+x)
                x := x + 1
            end  -- from x:= 0

            y := y + 1
        end  -- from y:= 0

        -- Now fade in the graphics palette
        default_graphics_palette.fade_in(1)

        -- Copy the default graphics palette
        fade_palette.copy(default_graphics_palette)

        -- Display the fade palette before we fade it (nothing should change)
        fade_palette.put

        -- Now fade out the palette
        fade_palette.fade_out(1)

        -- And fade it back in
        default_graphics_palette.fade_in(1)

        -- Free the memory for the fade palette
        fade_palette.discard


--------------------------------------------------- Line features

        -- Clear the screen
        screen.clear

        -- Draw num_iterations random lines
        from
            !!std_rand.make
            x := 0
        invariant
            0 <= x and x <= num_iterations
        variant
            num_iterations - x
        until
            x = num_iterations
        loop
-- Faster, but not Eiffel!
--            c_inline_c("_x1=random()%%320;")
--            c_inline_c("_y1=random()%%240;")
--            c_inline_c("_x2=random()%%320;")
--            c_inline_c("_y2=random()%%240;")
--            c_inline_c("_colour_index=random()%%256;")

-- Slower, but Eiffel!
            std_rand.next
            x1 := std_rand.last_integer(screen.visible_width)-1
            std_rand.next
            y1 := std_rand.last_integer(screen.visible_height)-1
            std_rand.next
            x2 := std_rand.last_integer(screen.visible_width)-1
            std_rand.next
            y2 := std_rand.last_integer(screen.visible_height)-1
            std_rand.next
            colour_index := std_rand.last_integer(256)-1
            screen.line(x1, y1, x2, y2, colour_index)

            x := x + 1
        end  -- from x := 0


--------------------------------------------------- Bitmap features

        -- Delete the bitmap file if it already exists
        if ace_file_tools.exists("screen.pcx") then
            i := ace_file_tools.delete("screen.pcx")
        end  -- if

        -- Save the visible portion of the screen
        !!visible_screen.make_as_sub_bitmap(screen,
                                            0, 0,
                                            screen.visible_width,
                                            screen.visible_height)
        !!save_load_palette.make
        save_load_palette.get

        if not visible_screen.save("screen.pcx", save_load_palette) then
            crash_with_message("Couldn't save the screen!")
        end  -- if

        -- Now load it back from disk and display it
        screen.clear
        !!load_bitmap.load("screen.pcx", save_load_palette)
        save_load_palette.put
        screen.blit(load_bitmap,
                    0, 0, load_bitmap.width, load_bitmap.height,
                    0, 0)


        -- Make an example bitmap
        !!bitmap.make(64,64)
        !!black_bitmap.make(64,64)
        bitmap.clear
        black_bitmap.clear
        screen.clear

        -- Draw something on it
        bitmap.filled_circle(bitmap.width//2-1, bitmap.height//2-1, bitmap.width//2-1, 1)
        bitmap.circle(bitmap.width//2-1, bitmap.height//2-1, bitmap.width//2-1, 14)
        bitmap.line(bitmap.width//2, 0, bitmap.width//2, bitmap.height-1, 14)
        bitmap.line(0, bitmap.height//2, bitmap.width-1, bitmap.height//2, 14)

        -- Masked blit the bitmap to the screen num_iterations times
        from
            x := 0
        invariant
            0 <= x and x <= num_iterations
        variant
            num_iterations - x
        until
            x = num_iterations
        loop
            std_rand.next
            x1 := std_rand.last_integer(screen.visible_width-bitmap.width)-1
            std_rand.next
            y1 := std_rand.last_integer(screen.visible_height-bitmap.height)-1
            screen.masked_blit(bitmap, x1, y1)
            x := x + 1
        end  -- from x := 0


        -- Make the dirty rectangle bitmap
        !!dirty_rectangle.make(70,70)
        dirty_rectangle.clear


        -- Rotate the bitmap for a couple of revolution
        screen.clear
        value := value.one

        -- Calculate the position to blit to on the screen
        x := screen.visible_width//2-bitmap.width//2
        y := screen.visible_width//2-bitmap.width//2

        from
            angle.from_integer(0)
            i := 0
        invariant
            0 <= i and i <= num_iterations
        variant
            num_iterations - i
        until
            i = num_iterations
        loop
            dirty_rectangle.clear
            dirty_rectangle.masked_rotate_blit(bitmap, 3, 3, angle)

            screen.vsync
            screen.blit(dirty_rectangle,
                        0, 0, dirty_rectangle.width, dirty_rectangle.height,
                        x, y)

            i     := i + 1
            angle := angle + value

            if angle.to_integer > 256 then
                angle.from_integer(0)
            end  -- if
        end  -- from angle.to_integer(0)

        -- Free the memory for the bitmaps
        bitmap.discard
        black_bitmap.discard
        dirty_rectangle.discard


--------------------------------------------------- Datafile features

        !!led_zep_datafile.make("ledzep.dat")
        led_zep_bitmap  := led_zep_datafile.load_bitmap("BITMAP_Led_Zeppelin")
        led_zep_palette := led_zep_datafile.load_palette("PALETTE_Led_Zeppelin")
        small_font      := led_zep_datafile.load_font("FONT_Small_Font_6pt")
        itchy_and_scratchy := led_zep_datafile.load_sample("SAMPLE_Itchy_and_Scratchy")
        minuet_in_g     := led_zep_datafile.load_midi("MIDI_Minuet_in_G")
        allegro         := led_zep_datafile.load_flic("FLIC_Allegro")

        -- Display the bitmap, then the palette (so both steps are visible)
        screen.clear
        screen.blit(led_zep_bitmap,
                    0, 0, led_zep_bitmap.width, led_zep_bitmap.height,
                    0, 0)
        led_zep_palette.put

        -- Now play both the sample and the MIDI file
        if soundcard.auto_init then
            screen.put_string(0, 0, 255, small_font, soundcard.digital_driver_name)
            screen.put_string(0, small_font.height, 255, small_font, soundcard.digital_driver_description)
            screen.put_string(0, small_font.height*2, 255, small_font, soundcard.midi_driver_name)
            screen.put_string(0, small_font.height*3, 255, small_font, soundcard.midi_driver_description)
            soundcard.set_digital_volume(255)
            soundcard.set_midi_volume(255)
            itchy_and_scratchy.play(255, 127, 1000, FALSE)  -- Don't loop
            minuet_in_g.play(TRUE)                          -- Loop
        end  -- if

        screen.put_string(0, screen.height-small_font.height-2, 255, small_font, "Press ENTER to continue...")
        io.read_character

        -- Stop any playing music
        itchy_and_scratchy.stop
        minuet_in_g.stop

        -- Play the Allegro FLIC
        allegro.play(screen)

        -- Discard datafile objects
        led_zep_bitmap.discard
        led_zep_palette.discard
        small_font.discard
        itchy_and_scratchy.discard
        minuet_in_g.discard


--------------------------------------------------- Clean up

        -- Return to text mode
        screen.shutdown


--------------------------------------------------- Stop timing and print elapsed time

        stop := timer.count
        timer.stop

        -- Print execution time
        duration := (stop - start) / 100
        io.put_string(duration.to_string_format(2))
        io.put_string(" seconds to run all tests.%N")

        -- Print a final message
        io.put_string("Tests completed succesfully!  Bye!%N")

        -- Print out free memory
        c_inline_c("_go32_dpmi_get_free_memory_information(_p);")
        c_inline_c("printf(%"ace_test end: %%U memory free\n%",((_go32_dpmi_meminfo *)_p)->available_memory);")
    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1024


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the ace error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class ACE_TEST
