/*
 * EXCEPTN.CPP - Contains exception handlers.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _EXCEPTN_CC_

#include "sysinfo.h"

extern "C" void interrupt exception_handler(...);

void interrupt (*exceptns[8])(...);

void set_exception_handlers()
{
	int f;
	for(f = 0; f <= 7; f++)
	{
		exceptns[f] = getvect(f);
		setvect(f, exception_handler);
	}
}

void reset_exception_handlers()
{
	int f;
	for(f = 0; f <= 7; f++)
	setvect(f, exceptns[f]);
}