/* pads the a given exe file to the next 512 byte boundary and */
/* includes a copyright notice in the header */
/* run this program on PMODSTUB.EXE after linking */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <string.h>

static char copyright[] =
 "%s generated on %.24s\r\n"
 "The %s stub loader is Copyright (C) 1993-1995 DJ Delorie.\r\n"
 "Permission granted to use for any purpose provided this copyright\r\n"
 "remains present and unmodified.\r\n"
 "This only applies to the stub, and not necessarily the whole program.\r\n";


/*unsigned long filesize( FILE *fp )
{
  unsigned long int save_pos, size_of_file;

  save_pos = ftell( fp );
  fseek( fp, 0L, SEEK_END );
  size_of_file = ftell( fp );
  fseek( fp, save_pos, SEEK_SET );
  return( size_of_file );
}*/

int main(int argc, char **argv)
{
  struct Head
  { unsigned short
      ID,
      Len_mod512,
      Len_blk512,
      NumReloc,
      HeaderSize,
      MinMem,
      MaxMem,
      ProgMem,
      Start_SP,
      CheckSum,
      Start_IP,
      Start_CodeSeg,
      RelocPos,
      OverlayNum;
  } head;

  char msg[1024];
  char *buff,*exe,*pack;
  size_t bufflen,exelen,newlen,off,msglen,packlen;
  time_t now;
  FILE *f;

  if (argc != 2)
  { printf("padsec <exefile>");
    return 1;
  }
  if ( (f = fopen(argv[1], "rb")) == NULL )
  { printf( "%s not found\n", argv[1] );
    return 1;
  }

  /* Make headermessage */
  memset(msg, 0, sizeof(msg));
  time(&now);
  sprintf(msg,copyright,argv[1],ctime(&now),argv[1]);
  msglen = (strlen(msg) + 2) & ~1;

  /* Read in Header */
  fread(&head, sizeof(head), 1, f);
  bufflen = (sizeof(head) + head.NumReloc*4 + msglen + 511) & ~ 511;
  if (bufflen > 512)
  { printf("Sorry, the exe header can't be larger than 512 bytes!\n");
    return 1;
  }
  buff = (char *)malloc(bufflen);
  memset(buff, 0, bufflen);
  off = 0;
  memcpy(buff+off, &head, sizeof(head)); off += sizeof(head);
  memcpy(buff+off, msg, msglen); off += msglen;
  fseek(f, head.RelocPos, SEEK_SET);
  fread(buff+off, head.NumReloc, 4, f);
  ((struct Head *)buff)->HeaderSize = bufflen / 16;
  ((struct Head *)buff)->RelocPos   = off;

  /* Read in rest of exefile, ignoring anything after */
  exelen = head.Len_blk512*512;
  if (head.Len_mod512) exelen = exelen - 512 + head.Len_mod512;
  exelen -= head.HeaderSize*16;
  newlen = (exelen + 511) & ~511;
  exe = (char *)malloc(newlen);
  memset(exe, 0, newlen);
  fseek(f, head.HeaderSize*16, SEEK_SET);
  fread(exe, exelen, 1, f);

  /* Try to remove trailing zeros in the .exe file */
  for (pack = exe + exelen; *--pack==0; ) ;
  packlen = (pack + 1 - exe + 511) & ~511;

  /* Set the new exe length */
  ((struct Head *)buff)->Len_blk512 = (packlen + bufflen) / 512;
  ((struct Head *)buff)->Len_mod512 = 0;
  ((struct Head *)buff)->MinMem     =
    (((exelen+15)&~15) + ((struct Head *)buff)->MinMem*16 - packlen) / 16;
  ((struct Head *)buff)->MaxMem     = ((struct Head *)buff)->MinMem;
  fclose(f);

  /* Write new exefile */
  if ( (f = fopen(argv[1], "wb")) == NULL)
  { printf("cannot open %s for writing\n", argv[1]);
    return 1;
  }
  fwrite(buff, bufflen, 1, f);
  fwrite(exe, packlen, 1, f);
  fclose(f);
  free(buff);
  free(exe);

  return 0;
}
