/* deletefile.c -- delete file 
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_delete_file(
		IN LPCSTR lpFileName,
		IN WORD wWildcard,
		IN BYTE nSearchAttr,
		IN BYTE nMustMatchAttr)
{
	WORD	result ;
	HANDLE 	handle;
	BYTE	nFoundAttr ;
	WIN32_FIND_DATA FindStruct;

	PROLOG(process_delete_file);
	IS_NULL(lpFileName, ERROR_FILE_NOT_FOUND);	
	IS_MAX_PATH_SIZE(lpFileName);

	DBGVALUE(lpFileName,"%s");
	DBGVALUE(wWildcard,"%d");
	DBGVALUE(nSearchAttr   ,"%d");
	DBGVALUE(nMustMatchAttr,"%d");

	switch(wWildcard)
	{
		case LONG_DELETE_FILE_NO_WILDCARDS:
			if (!DeleteFile(lpFileName)) {
				result = (WORD)GetLastError();
				DBGMSG("Cannot delete file");	
			} else 
				result = ERROR_SUCCESS;
			EPILOG(process_delete_file,TRUE);
			return result;
		case LONG_DELETE_FILE_WILDCARDS:
			break;       
		default:
			EPILOG(process_delete_file,TRUE);
			return ERROR_INVALID_FUNCTION;
	}	
//	After all this function is supposed to deal with files only
	nSearchAttr     &= ~(FILE_ATTR_DIRECTORY|FILE_ATTR_VOLUME_LABEL);
	nMustMatchAttr  &= ~(FILE_ATTR_DIRECTORY|FILE_ATTR_VOLUME_LABEL);
	nSearchAttr     &= (FILE_ATTR_READONLY|FILE_ATTR_HIDDEN|FILE_ATTR_SYSTEM|FILE_ATTR_ARCHIVE);     
	nMustMatchAttr  &= (FILE_ATTR_READONLY|FILE_ATTR_HIDDEN|FILE_ATTR_SYSTEM|FILE_ATTR_ARCHIVE);     

	DBGVALUE(nSearchAttr   ,"%d");
	DBGVALUE(nMustMatchAttr,"%d");

	memset(&FindStruct, 0, sizeof (WIN32_FIND_DATA));	
	if ((handle = FindFirstFile(lpFileName, &FindStruct)) == INVALID_HANDLE_VALUE) {
		result = (WORD)GetLastError();
		EPILOG(process_delete_file,TRUE);
		return result;   
	} 

	nFoundAttr =  LOBYTE(LOWORD(FindStruct.dwFileAttributes));
	nFoundAttr &= (FILE_ATTR_READONLY|FILE_ATTR_HIDDEN|FILE_ATTR_SYSTEM|FILE_ATTR_ARCHIVE);     

	DBGVALUE(FindStruct.cFileName,"%s");
	DBGVALUE(FindStruct.cAlternateFileName,"%s");
	DBGVALUE(nFoundAttr,"%d");

	DBGVALUE((((nMustMatchAttr & ~nFoundAttr) & 0x3F) == 0),"%d");
	DBGVALUE((((~nSearchAttr & nFoundAttr) & 0x1E) == 0),"%d");

	if ((((nMustMatchAttr & ~nFoundAttr) & 0x3F) == 0)
	    && (((~nSearchAttr & nFoundAttr) & 0x1E) == 0)) 
		if (!DeleteFile(lpFileName)) {
			result = (WORD)GetLastError();
			DBGMSG("Cannot delete file");	
			DBGVALUE(result,"%d");
		} 

	while (FindNextFile(handle, &FindStruct)) {
		nFoundAttr =  LOBYTE(LOWORD(FindStruct.dwFileAttributes));
		nFoundAttr &= (FILE_ATTR_READONLY|FILE_ATTR_HIDDEN|FILE_ATTR_SYSTEM|FILE_ATTR_ARCHIVE);     
		DBGVALUE(FindStruct.cFileName,"%s");
		DBGVALUE(FindStruct.cAlternateFileName,"%s");
		DBGVALUE(nFoundAttr,"%d");

		if ((((nMustMatchAttr & ~nFoundAttr) & 0x3F) == 0)
		    && (((~nSearchAttr & nFoundAttr) & 0x1E) == 0)) 
			if (!DeleteFile(lpFileName)) {
				result = (WORD)GetLastError();
				DBGMSG("Cannot delete file");	
				DBGVALUE(result,"%d");
			}	
	}

	FindClose(handle);
	DBGMSG("Delete passed");
	EPILOG(process_delete_file,TRUE);
	return ERROR_SUCCESS;
}

