AC_DEFUN(GST_HAVE_READLINE, [

AC_ARG_WITH(readline, 
	[  --with-readline=path    set path to readline and termcap libraries
  --without-readline      don't try to detect readline])


AC_CACHE_CHECK(how to link with readline, gst_cv_readline_libs, [
if test "$with_readline" != no; then
  test "$with_readline" && test -d "$with_readline" && \
    LDFLAGS="$LDFLAGS -L$with_readline"
  gst_cv_readline_libs="not found"
  ac_save_LIBS="$LIBS"
  for lib in "" -ltermcap -ltermlib -lncurses; do
    LIBS="$ac_save_LIBS -lreadline $lib"
    AC_TRY_LINK(
      [#include <stdio.h>
      #include <readline/readline.h>],
      [char *l = readline("")],
      [gst_cv_readline_libs="-lreadline $lib"
      break])
  done
  LIBS="$ac_save_LIBS"
fi])

if test "$gst_cv_readline_libs" != "not found"; then
  LIBS="$LIBS $gst_cv_readline_libs"
  AC_DEFINE(HAVE_READLINE, 1, [Define this if you want the ultra-winning GNU readline library to be present in the command reader.])
fi

])dnl
