"======================================================================
|
|   Smalltalk GUI browser initialization script
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

"Smalltalk blox+browser initialization script"

| verbose |

Transcript nl; nextPutAll: 'Initializing system -- be patient...'; nl.

verbose := FileStream verbose: true.

(Namespace current includesKey: #BrowserMain)
    ifTrue: [ (Namespace current at: #BrowserMain) close ].


#(

"Load our dependancy system and graphics kernel"
  'blox/GuiData.st'
  'blox/View.st'
  'blox/Manager.st'
  'blox/RadioForm.st'
  'blox/Menu.st'
  'blox/ModalDialog.st'
  'blox/PList.st'
  'blox/PText.st'

"View classes"
  'examples/Buffers.st'
  'blox/PCode.st'		"Syntax highlighting is here"
  'blox/BrowShell.st'
  'blox/BrowserMain.st'
  'blox/ClassBrow.st'
  'blox/MethSetBrow.st'
  'blox/Inspector.st'
  'blox/DictInspect.st'
  'blox/MethInspect.st'
  'blox/StrcInspect.st'

"Load files that support Steve's walkback inspector"
  'blox/CtxtInspect.st'
  'blox/Notifier.st'
) do: [ :file | FileStream fileIn: Directory kernel, '/../', file ].

FileStream verbose: verbose!

Collection removeSelector: #inspect ifAbsent: [ ].
SequenceableCollection removeSelector: #inspect ifAbsent: [ ]!
