program fjf541b;

const
  Eps = 1e-14;

function RealEq (const a, b: LongestReal): Boolean;
begin
  RealEQ := Abs (a - b) <= Eps * (SqRt (Sqr (a) + Sqr (b)) + 1)
end;

procedure Check (const a, b: Complex);
var n: static Integer = 0;
begin
  Inc (n);
  if not RealEq (Re (a), Re (b)) or not RealEq (Im (a), Im (b)) then
    begin
      Writeln ('failed ', n, ': ', Re (a):0:4, '+', Im (a):0:4, 'i (',
               Re (b):0:4, '+', Im (b):0:4, 'i)');
      Halt
    end
end;

begin
  Check (Polar (2.0, Pi / 2), Cmplx (0.0, 2.0));
  Check (Polar (2.0, Pi / 2), Cmplx (0.0, 2));
  Check (Polar (2.0, Pi / 2), Cmplx (0, 2.0));
  Check (Polar (2.0, Pi / 2), Cmplx (0, 2));
  Check (Polar (2, Pi / 2), Cmplx (0, 2));
  Check (Polar (3.0, 2.0), Cmplx (3 * Cos (2), 3 * Sin (2)));
  Check (Polar (3.0, 2), Cmplx (3 * Cos (2), 3 * Sin (2)));
  Check (Polar (3, 2.0), Cmplx (3 * Cos (2), 3 * Sin (2)));
  Check (Polar (3, 2), Cmplx (3 * Cos (2), 3 * Sin (2)));
  Writeln ('OK')
end.
