/*Global C definitions for the GPC Run Time System.

  Copyright (C) 1985-2002 Free Software Foundation, Inc.

  Authors: Jukka Virtanen <jtv@hut.fi>
           J.J. van der Heijden <j.j.vanderheijden@student.utwente.nl>
           Frank Heckenbach <frank@pascal.gnu.de>

  1985-06-15: First version for Pax compiler at hut.fi.

  Later converted for GNU Pascal Compiler (GPC). The Run Time System
  should support all features of the Extended Pascal Standard.

  This file is part of GNU Pascal.

  GNU Pascal is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation; either version 2, or (at your
  option) any later version.

  GNU Pascal is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNU Pascal; see the file COPYING. If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  As a special exception, if you link this file with files compiled
  with a GNU compiler to produce an executable, this does not cause
  the resulting executable to be covered by the GNU General Public
  License. This exception does not however invalidate any other
  reasons why the executable file might be covered by the GNU
  General Public License. */

#if defined (MSDOS) || defined (_WIN32) || defined (__EMX__)
#define __OS_DOS__
#endif

/* These should be consistent with configure.in */
#define _GNU_SOURCE
#define _LARGEFILE64_SOURCE
#define _FILE_OFFSET_BITS 64

/* Created by autoconf */
#ifndef HAVE_NO_RTS_CONFIG_H
#include "rts-config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifndef HAVE_SSIZE_T
typedef signed long ssize_t;
#endif

#include "constants.h"

#define False 0
#define True  1

/* struct Fdr is defined in file.c where it's exclusively used */
typedef struct Fdr *FDR;

/* These types are hard-coded in the compiler. Do not change here. */
typedef unsigned char Boolean;
typedef unsigned char Char;
typedef long long int LongestInt;
typedef unsigned long long int LongestCard;
typedef long long int UnixTimeType;

typedef long long int FileSizeType;
typedef long long int MicroSecondTimeType;

typedef struct
{
  int Handle;
  Boolean Read, Write, Exception;
} InternalSelectType;

/* for _p_SeekHandle() */
#define P_SEEK_SET 0
#define P_SEEK_CUR 1
#define P_SEEK_END 2

/* heap.pas */
void *_p_new (size_t);
void _p_dispose (const void *);
void _p_reallocmem (void **, size_t);

/* numtodec.pas */
extern int _p_low_integer;

/* filename.pas */
extern char _p_dirseparatorvar;

/* string.pas */
extern const char **_p_argv;
size_t _p_strlen (const char *);
char *_p_strdup (const char *);
int _p_strcmp (const char *, const char *);
char *_p_strlcpy (char *, const char *, size_t);
char *_p_strscan (const char *, char);

/* move.pas */
void _p_move (const void *, void *, size_t);

/* error.pas */
void _p_atexit (void (*proc) (void));
void *_p_SetTempDummyReturnAddress (void);
void _p_RestoreTempReturnAddress (void *);

void _p_SetReturnAddress (void *);
#define SAVE_RETURN_ADDRESS _p_SetReturnAddress (__builtin_return_address (0))
void _p_RestoreReturnAddress (void);
#define RESTORE_RETURN_ADDRESS _p_RestoreReturnAddress ()
#define DO_RETURN_ADDRESS(stmt) \
do \
  { \
    SAVE_RETURN_ADDRESS; \
    stmt; \
    RESTORE_RETURN_ADDRESS; \
  } \
while (0)

#define NORETURN __attribute__((noreturn))
void _p_error (int) NORETURN;
#define _p_error(n)                     DO_RETURN_ADDRESS (_p_error (n))
void _p_error_errno (int) NORETURN;
#define _p_error_errno(n)               DO_RETURN_ADDRESS (_p_error_errno (n))
void _p_internal_error (int) NORETURN;
#define _p_internal_error(n)            DO_RETURN_ADDRESS (_p_internal_error (n))

/* This is to suppress warnings about missing prototypes for C functions that
   are only called from Pascal (and possibly the same C file), i.e. where
   we actually wouldn't need a prototype, but can't declare them static. */
#define GLOBAL(decl) decl; decl
#define GLOBAL_ATTR(decl, attr) decl __attribute__((attr)); decl
