/* util.h -- interface for util.c
   Copyright (C) 1997-2000 Free Software Foundation, Inc.

This file is part of GNU Pascal.

GNU Pascal is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Pascal is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Pascal; see the file COPYING. If not, write to the
Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.

   Owning Modules:
      util.c

   Modifications:
*/

/* Allow multiple inclusion to work. */

#ifndef _GPC_UTIL_H_
#define _GPC_UTIL_H_

/* Include files needed by this one. */


/* Structure definitions. */


/* Simple definitions and enumerations. */

#define VQ_EXTERNAL   0x01
#define VQ_STATIC     0x02
#define VQ_VOLATILE   0x04
#define VQ_REGISTER   0x08
#define VQ_TYPEDCONST 0x10

/* Typedefs. */


/* Include files needed by this one. */


/* Structure definitions. */


/* Global objects accessed by users of this module. */

extern char *gpc_main;
extern int flag_interface_only;
extern int flag_implementation_only;
extern int warn_field_name_problem;
extern int warn_typed_const;
extern int warn_near_far;
extern int warn_underscore;
extern int main_program_has_nonlocal_label;
extern int main_program_needs_context;
extern int main_program_first_label_num;
extern tree main_program_named_labels;
extern tree main_program_nonlocal_labels;
#if 0
extern rtx main_program_tail_recursion_reentry;
extern rtx main_program_nonlocal_goto_handler_slot;
extern rtx main_program_nonlocal_goto_stack_level;
#endif
extern char *executable_file_name;
extern char *executable_path;
extern char *unit_destination_path;
extern char *object_destination_path;
extern int flag_no_default_paths;
extern char *gpi_destination_path;
extern char *extra_imports;
extern int requested_set_size;
extern tree integer_set_size;
extern int int_out_width;
extern int real_out_width;
extern int bool_out_width;
extern int long_int_out_width;
extern int long_real_out_width;
extern tree integer_set_type_node;
extern tree integer_ptr_type_node;
extern tree size_of_file_type;
#ifdef EGCS
extern tree size_unit_of_file_type;
#endif
extern tree boolean_type_node;
extern tree text_type_node;
extern tree complex_type_node;
extern tree identifier_input;
extern tree identifier_output;
extern tree identifier_stderr;
extern tree global_input_file_node;
extern tree global_output_file_node;
extern tree global_error_file_node;
extern tree char_array_index_type_node;
extern tree string_schema_proto_type;
extern tree const_string_schema_proto_type;
extern tree cstring_type_node;
extern tree empty_arglist;

extern tree gpc_type_TIME;
extern tree gpc_type_DATE;
extern tree gpc_type_TIMESTAMP;
extern tree gpc_type_BINDINGTYPE;

extern tree string_id;
extern tree schema_id;
extern tree const_id;
extern tree type_id;
extern tree inline_id;
extern tree varparm_id;
extern tree volatile_id;
extern tree register_id;
extern tree auto_id;
extern tree extern_id;
extern tree asmname_id;
extern tree static_id;
extern tree attribute_id;

extern tree collect_constructors_now;


/* Declare functions with prototypes. */

/* Identifiers */
/* Note: The first parameter to get_unique_identifier() must not be longer than 200 chars! */
extern tree get_unique_identifier PARAMS ((char *, int));
extern tree get_identifier_with_blank PARAMS ((char *));
extern tree check_identifier PARAMS ((tree, tree));

/* Variables */
/* Note: The first parameter to make_new_variable() must not be longer than 200 chars! */
extern tree make_new_variable PARAMS ((char *, tree));
extern tree alloca_string PARAMS ((tree));
extern tree new_string_by_model PARAMS ((tree, tree, int));
extern void declare_vars PARAMS ((tree, tree, tree, char *, unsigned, int, tree ));
extern tree build_string_move PARAMS ((tree, tree, tree));
extern tree build_string_pad PARAMS ((tree, tree, tree));

/* Parameters */
extern void handle_formal_conf_array_param_list PARAMS ((tree, tree, int, int));
extern void handle_formal_param_list PARAMS ((tree, tree, tree, int, int));

/* Initializers */
extern void assign_tags PARAMS ((tree, tree));
extern void init_any PARAMS ((tree, int));
extern void un_initialize_block PARAMS ((tree, int));
extern tree build_pascal_initializer PARAMS ((tree, tree));

/* Procedure and Function calls */
extern int suspend_function_calls PARAMS ((void));
extern int allow_function_calls PARAMS ((void));
extern void resume_function_calls PARAMS ((int));
extern tree function_return_type PARAMS ((tree));
extern tree maybe_call_function PARAMS ((tree, tree));
extern tree probably_call_function PARAMS ((tree));
extern struct function *maybe_find_function_data PARAMS ((tree));

/* Main program */
extern void do_setjmp PARAMS ((void));
extern void output_real_main_program PARAMS ((tree));
extern tree get_main_program_name PARAMS ((tree));
extern void generate_main_program_rtx PARAMS ((void));
extern void init_main_program_rtx PARAMS ((void));
extern void expand_goto_main_program PARAMS ((tree));
extern void pascal_expand_goto PARAMS ((tree));
extern void finish_program_component PARAMS ((void));
extern void exit_compilation PARAMS ((void));

/* GPC startup */
extern void init_util PARAMS ((void));
extern void pascal_init_options PARAMS ((void));
extern void pascal_init PARAMS ((void));
extern void start_constructor PARAMS ((void));
extern void finish_constructor PARAMS ((void));

/* Miscellaneous */
extern void pushlevel_expand PARAMS ((void));
extern tree poplevel_expand PARAMS ((void));
extern void check_for_control_variable PARAMS ((tree));
extern void typed_const_warning PARAMS ((tree));
extern void object_directive_warning PARAMS ((void));
extern tree no_parameters PARAMS ((void));
#ifndef EGCS92
extern char *concat PVPARAMS ((char *, ...));
#endif
extern char *save_string PARAMS ((char *));

/* Utility functions */
extern int contains_file_p PARAMS ((tree));
extern int contains_file_or_schema_p PARAMS ((tree));
extern void declare_known_ids PARAMS ((void));

/* Define macros. */

/* Shorthands used in building integer range types
 * A is a tree type low_bound and B is an INT value of the high_bound
 */
#define INT_RANGE_TYPE(a,b) \
        build_range_type (integer_type_node, a, build_int_2 (b, 0))

/* Makes life easier with required record types */
#define DO_FIELD(name, type)                                 \
        grokfield (input_filename, 0, get_identifier (name), \
                   build_tree_list (NULL_TREE, type), NULL_TREE)

/* End of #include file. */

#endif /* _GPC_UTIL_H_ */
