program DPMIDemo;

{ Only for DJGPP }

{$X+}

{ `Byte' is `unsigned char' in C,
  `ShortCard' is `unsigned short' in C,
  `MedCard' is `unsigned long' in C,
  `Word' is `unsigned' in C,
  etc. (all these types are built-in). }

type
  TDpmiVersionRet = record
    Major      : Byte;
    Minor      : Byte;
    Flags      : ShortCard;
    CPU        : Byte;
    Master_PIC : Byte;
    Slave_PIC  : Byte;
  end;

type
  TDpmiFreeMemInfo = record
    Largest_Available_Free_Block_In_Bytes,
    Maximum_Unlocked_Page_Allocation_In_Pages,
    Maximum_Locked_Page_Allocation_In_Pages,
    Linear_Address_Space_Size_In_Pages,
    Total_Number_Of_Unlocked_Pages,
    Total_Number_Of_Free_Pages,
    Total_Number_Of_Physical_Pages,
    Free_Linear_Address_Space_In_Pages,
    Size_Of_Paging_File_Partition_In_Pages,
    Reserved1,
    Reserved2,
    Reserved3 : MedCard;
  end;

function DpmiGetVersion (var Version: TDpmiVersionRet): Integer;
         asmname '__dpmi_get_version';

function DpmiGetFreeMemoryInformation
         (var MemInfo: TDpmiFreeMemInfo): Integer;
         asmname '__dpmi_get_free_memory_information';

var
  Version: TDpmiVersionRet;
  MemInfo: TDpmiFreeMemInfo;

begin
  if DpmiGetVersion (Version) = 0 then
    begin
      WriteLn ('CPU type :       ', Version.cpu, '86');
      WriteLn ('DPMI major :       ', Version.Major);
      WriteLn ('DPMI minor :       ', Version.Minor);
    end
  else
    WriteLn ('Error in DpmiGetVersion');
  if DpmiGetFreeMemoryInformation (MemInfo) = 0 then
    WriteLn ('Free DPMI memory : ',
             MemInfo.Total_Number_Of_Free_Pages, ' pages.')
  else
    WriteLn ('Error in DpmiGetMemoryInformation');
end.
