/******************************** -*- C -*- ****************************
 *
 *	putenv substitute
 *
 *	$Revision: 1.7.5$
 *	$Date: 2000/05/28 16:56:52$
 *	$Author: pb$
 *
 ***********************************************************************/

/***********************************************************************
 *
 * Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
 *
 * This file is part of the GNU C Library.
 * 
 * The GNU C Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 * 
 * The GNU C Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should receive a copy of the GNU Lesser General Public License
 * along with the GNU C Library; see the file COPYING.LESSER.  If not, write
 * to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "gst.h"
#include "alloc.h"

#include <errno.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#endif /* STDC_HEADERS */

/* The following file does not exist in NEXSTEP 2.1.
 * The omission of this include does not generate an error
 * in NEXTSTEP versions 2.1,3.1,3.2  brd Fri Jan 21 22:54:38 PST 1994
 */
#ifndef NeXT
#include <unistd.h> 
#endif
 
extern char **environ;
#define	__environ	environ

/* Put STRING, which is of the form "NAME=VALUE", in the environment.  */
int putenv(const char *string)
{
  char *name_end = strchr(string, '=');
  register size_t size;
  register char **ep;

  if (name_end == NULL)
    {
      /* Remove the variable from the environment.  */
      size = strlen(string);
      for (ep = __environ; *ep != NULL; ++ep)
	if (!strncmp(*ep, string, size) && (*ep)[size] == '=')
	  {
	    while (ep[1] != NULL)
	      {
		ep[0] = ep[1];
		++ep;
	      }
	    *ep = NULL;
	    return 0;
	  }
    }

  size = 0;
  for (ep = __environ; *ep != NULL; ++ep)
    if (!strncmp(*ep, string, name_end - string) &&
	(*ep)[name_end - string] == '=')
      break;
    else
      ++size;

  if (*ep == NULL)
    {
      static char **last_environ = NULL;
      char **new_environ = (char **) xmalloc((size + 2) * sizeof(char *));
      if (new_environ == NULL)
	return -1;
      (void) memcpy((voidPtr) new_environ, (voidPtr) __environ, size * sizeof(char *));
      new_environ[size] = (char *) string;
      new_environ[size + 1] = NULL;
      if (last_environ != NULL)
	xfree((voidPtr) last_environ);
      last_environ = new_environ;
      __environ = new_environ;
    }
  else
    *ep = (char *) string;

  return 0;
}


