/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
/*
 $Id: tvutilfu.h,v 1.5 1997-09-19 09:28:33+00 rho Exp rho $
*/
#if !defined( tvutilFunctions__ )
#define tvutilFunctions__

class TWindow;
void AddWindow(TWindow *,TWindow **ref = NULL,Boolean before = False,
               Boolean remember_closed = False, Boolean is_removable = True);
void RemoveWindow(TWindow *, Boolean remember_closed = True);
void UpdateWindow(TWindow *window);
void ShowWindowList(const char *);
void ClearWindowList();
int IsClosedWindow(const char *);
TWindow *OpenClosedWindow(int);
class opstream;
void SaveClosedWindows(opstream &);
class ipstream;
void LoadClosedWindows(ipstream &);

class TSCollection;
extern TSCollection *windows;
extern TSCollection *closed_windows;
extern int max_closed;
#define DESKTOPWINDOW(index) (((DeskTopWindow *)windows->at(index))->window)

class TParamList;
ushort editParamList(TParamList *paramlist, const char *title,int hist_id);

class TDirList;
void editDirList(TDirList *dirlist, const char *title,int hist_id);

class TRect;
ushort BigmessageBox( const char *msg, ushort aOptions );
ushort BigmessageBox( ushort aOptions, const char *fmt, ... )
                __attribute__ ((format (printf, 2, 3)));
ushort BiginputBox( const char *Title, const char *aLabel, char *s, int limit );
ushort HistinputBox( const char *Title, const char *aLabel, char *s,
                     int limit, int hist_id );
class TValidator;
ushort ValidInputBox( const char *Title, const char *aLabel, char *s,
                      int limit, TValidator * validator);

extern int hist_id_count;
extern int *hist_ids;
void InitHistoryID(int);
void ClearHistoryIDs();
class ipstream;
void LoadHistoryIDs(ipstream &);
class opstream;
void SaveHistoryIDs(opstream &);

int InputInt(int &retval, const char *title, const char *label_name);
int InputUInt(unsigned int &retval, const char *title, const char *label_name);

void add_command_constant(const char *name,unsigned short value);
void add_help_constant(const char *name, unsigned short value);

#endif
