/***************************************************************/
/*                                                             */
/*  this header-file was modified by Robert Hoehne             */
/*  to use it with DJ's port of gcc                            */
/*                                                             */
/***************************************************************/


/*----------------------------------------------------------*/
/*                                                          */
/*   Turbo Vision 1.0                                       */
/*   Copyright (c) 1991 by Borland International            */
/*                                                          */
/*   Turbo Vision TVEDIT header file                        */
/*----------------------------------------------------------*/

#if defined( Uses_TEditorApp ) && !defined( __TEditorApp )
#define __TEditorApp

const ushort
  cmOpen       = 100,
  cmNew        = 101,
  cmChangeDrct = 102,
  cmDosShell   = 103,
  cmCalculator = 104,
  cmShowClip   = 105,
  cmMacros     = 106;

#ifdef STANDALONE
const cmInfView = 106,
      cmListWin = 107,
      cmLastHelp= 108,
      cmUserScreen=109;
const cmGo     = 900,
      cmDelete = 901;
const hcListWin=0x2110;
#endif

class TMenuBar;
class TStatusLine;
class TEditWindow;
class TDialog;
class fpstream;
class TCEditWindow;

class TEditorApp : public TApplication
{

public:

    TEditorApp();

    virtual void handleEvent( TEvent& event );
    static TMenuBar *initMenuBar( TRect );
    static TStatusLine *initStatusLine( TRect );
    virtual void outOfMemory();
    virtual TPalette& getPalette() const;
    void createClipBoard(void);
#ifdef STANDALONE
    void retrieveDesktop();
    void saveDesktop();
    void storeDesktop(fpstream& s);
    void loadDesktop(fpstream& s);
#endif
#if defined(STANDALONE) || defined(RHIDE)
    void executeCalc(void);
#endif
#ifdef STANDALONE
    void ShowUserScreen(TEvent &event);
#endif

    virtual TCEditWindow *openEditor( char *fileName, Boolean visible );

protected:

    virtual void fileOpen();
    void fileNew();
    void changeDir();
    virtual void dosShell();
    void showClip();
    void tile();
    void cascade();
};

extern TCEditWindow *clipWindow;

ushort execDialog( TDialog *d, void *data );
TDialog *createFindDialog();
TDialog *createReplaceDialog();
TDialog *createGotoLineDialog();
TDialog *createSetLocalOptions();
TDialog *createSetGlobalOptions();
ushort doEditDialog( int dialog, ... );


#endif
