/* $Id: query.h,v 1.11 2002/04/21 12:52:59 richdawe Exp $ */

/*
 *  query.h - Header for query routines for zippo
 *  Copyright (C) 1999-2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __zippo_query_h__
#define __zippo_query_h__

/* --- Constants --- */

/* Query modifiers */
enum {
  QM_NONE                  = 0x00000000,

  /* Package information */
  QM_SHORTINFO             = 0x00000001,
  QM_LONGINFO              = 0x00000002,

  /* Package files */
  QM_LISTFILES             = 0x00000004,
  QM_HASFILE               = 0x00000008,

  /* Package dependencies */
  QM_REQUIRES              = 0x00000010,
  QM_DEPENDS_ON            = 0x00000020,
  QM_CONFLICTS_WITH        = 0x00000040,
  QM_REPLACES              = 0x00000080,
  QM_PROVIDES              = 0x00000100,
  QM_INSTALL_BEFORE        = 0x00000200,
  QM_INSTALL_AFTER         = 0x00000400,
  QM_ALLDEPS               = 0x00000800,
  
  /* Files */
  QM_CHANGELOG             = 0x00001000,
  QM_PRE_INSTALL_README    = 0x00002000,
  QM_POST_INSTALL_README   = 0x00004000,
  QM_PRE_UNINSTALL_README  = 0x00008000,
  QM_POST_UNINSTALL_README = 0x00010000,
  QM_INSTALL_WARNING       = 0x00020000
};

/* Query return codes */
#define QUERY_FAILED	0	/* Hmmm, descriptive  */
#define QUERY_OK      	1	/* Generic OK code    */
#define QUERY_UNMATCHED	2	/* No match(es) found */

/* --- Structures --- */

/* Query data */
typedef struct {
  int	op;			/* Query operation                  */
  int	mod;			/* Query modifier                   */
  int	verbosity;		/* Query verbosity                  */
  int   interactive;		/* Ask the user questions?          */
  char	*root;			/* DJGPP/spec'd root directory      */
  char	*prefix;		/* Prefix to use for non-db actions */
  char	*name;			/* Query package name               */
  char	*qname;			/* Query name data, e.g. a filename */
  char	**dsm_path;		/* DSM path list                    */
  char	**mft_path;		/* Manifest path list               */
  char	**dsm_path_avail;       /* Available DSM path list          */
} ZIPPO_QUERY;

/* --- Functions --- */
extern int perform_query           (const ZIPPO_QUERY *req);
extern int perform_query_file      (const ZIPPO_QUERY *req);
extern int perform_query_all       (const ZIPPO_QUERY *req);
extern int perform_query_all_avail (const ZIPPO_QUERY *req);

extern int query_show_info (const int qm,
			    const int verbosity,
			    PACKAGE_INFO *package,
			    const char *rname);

extern int query_show_deps (const int qm,
			    const int verbosity,
			    PACKAGE_INFO *package);

extern int query_show_all_deps (const int verbosity,
				PACKAGE_INFO *package);

extern int query_show_info_header (PACKAGE_INFO *package);

extern int query_show_file (const int qm,
			    const int verbosity,
			    PACKAGE_INFO *package,
			    const char *rname);

extern int query_show_files (const char **mft_path,
			     PACKAGE_INFO *package,
			     const char *db_path,
			     const char *qfilename);

#endif	/* __zippo_query_h__ */
