/* $Id: fnsplit.h,v 1.1 2001/08/10 21:19:05 richdawe Exp $ */

/*
 *  fnsplit.h - Decompose a path into its components
 *  Copyright (C) 2000, 2001 by Richard Dawe
 *      
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __fnsplit_h__
#define __fnsplit_h__

#ifndef HAVE_FNSPLIT

#include <limits.h>

/* Limits on each component */
#ifndef MSDOS
#define MAXDRIVE 0
#else /* MSDOS */
#define MAXDRIVE 3
#endif /* !MSDOS */

#define MAXPATH PATH_MAX
#define MAXDIR  NAME_MAX
#define MAXFILE NAME_MAX
#define MAXEXT  (NAME_MAX - 1)

/* Return codes */
#define WILDCARDS 0x01
#define EXTENSION 0x02
#define FILENAME  0x04
#define DIRECTORY 0x08
#define DRIVE     0x10

extern int fnsplit (const char *path, char *drive, char *dir,
		    char *name, char *ext);

#else /* HAVE_FNSPLIT */

#ifdef MSDOS
#include <dir.h>
#endif /* MSDOS */

#endif /* !HAVE_FNSPLIT */

#endif /* __fnsplit_h__ */
