/* $Id: install.h,v 1.13 2002/05/05 13:41:09 richdawe Exp $ */

/*
 *  install.h - Header for install routines for zippo
 *  Copyright (C) 1999-2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __zippo_install_h__
#define __zippo_install_h__

/* --- Constants --- */

/* Install modifiers */
enum {
  IM_NONE = 0x00,
  IM_TEST = 0x01
};

/* --- Structures --- */

/* Install data */
typedef struct {
  int	 op;                /* Install operation                   */
  int	 mod;               /* Install modifier                    */
  int	 verbosity;         /* Install verbosity                   */
  int    interactive;       /* Ask the user questions?             */
  char	*root;              /* DJGPP/spec'd root directory         */
  char	*prefix;            /* Prefix to use for non-db actions    */
  char  *backup_prefix;     /* Prefix to store backups under       */
  char  *download_prefix;   /* Prefix to store downloaded archives */
  char	*name;              /* Install package name                */
  char **dsm_path;          /* Installed DSM path list             */
  char **dsm_path_avail;    /* Available DSM path list             */
  char **mft_path;          /* Installed manifest path list        */
  char **zip_path;          /* ZIP archive path list               */
  char **tar_gzip_path;     /* .tar.gz archive path list           */
  char **tar_bzip2_path;    /* .tar.bz2 archive path list          */
} ZIPPO_INSTALL;

/* --- Functions --- */
extern int perform_install (const ZIPPO_INSTALL *req);

extern int perform_install_avail (const ZIPPO_INSTALL *req);

extern int install_get_and_check_archives (PACKAGE_INFO *package,
					   const int verbosity,
					   const int interactive,
					   const char *req_name,
					   const char *download_prefix,
					   const char **archive_paths);

extern int install_download_archives (PACKAGE_INFO *package,
				      const int verbosity,
				      const char **archive_paths,
				      const char *download_to);

extern int install_extract_archive (PACKAGE_INFO *package,
				    const int verbosity,
				    const int interactive,
				    const int dup_action,
				    const char *req_name,
				    const char *prefix,
				    const char *backup_prefix,
				    const char **zip_path);

extern int install_dsm (PACKAGE_INFO *package,
			const char *db_path,
			const char *dsm);

extern int install_info_entries (PACKAGE_INFO *package,
				 const char *db_path,
				 const char *prefix);

#endif	/* __zippo_install_h__ */
