// packages.h - class for working with packages, pkg_list.
//    Copyright (C) 2000, 2001 Laurynas Biveinis <lauras@softhome.net>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#ifndef PACKAGES_H_
#define PACKAGES_H_

#include "global.h"
#include "log.h"
#include "scroldlg.h"

#define Uses_TCheckBoxes
#define Uses_TRect
#define Uses_TSItem
#include <rhtvision/tv.h>

#include <libzippo/package.h>
#include <libzippo/packlist.h>

class pkg_list
{
   public:
      pkg_list(const char * dj_dir, const char * zip_dir, 
               const log_file & where_to_log);
      ~pkg_list(void);
      void install(void);

   private:

      class pkg_checkbox : public TCheckBoxes
      {
         public:
            pkg_checkbox(PACKAGE_INFO * package);
            virtual void press(int item);

         private:
            PACKAGE_INFO * pkg;
      };

      class pkg_dialog : public scroll_dialog
      {
         public:
            pkg_dialog(PACKAGE_INFO * list);
            virtual void handleEvent(TEvent & event);

         private:
            void insert_packages(const int type) const;
            static int list_browser(PACKAGE_INFO * pkg, void * pkg_dialog);
            // Context for browser function
            struct info
            {
               int                   type;
               int                   encountered;
               pkg_list::pkg_dialog *dialog;
            };
            PACKAGE_INFO * packages;
      };
      const log_file   * log;
      PACKAGE_INFO     * packages;
};

inline void pkg_list::pkg_dialog::insert_packages(const int type) const
{
   struct info args;
   args.type = type;
   args.encountered = 0;
   args.dialog = (pkg_list::pkg_dialog *)this;
   packlist_browse(packages, list_browser, &args);
}

#endif
