/* $Id: rcfile.h,v 1.6 2002/01/13 12:46:45 richdawe Exp $ */

/*
 *  rcfile.h - Configuration file functions for zippo
 *  Copyright (C) 1999-2001 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>

#ifndef __zippo_rcfile_h__
#define __zippo_rcfile_h__

/* Default filenames */
#define RCFILE_DEFAULT          "zipporc"
#define RCFILE_PERSONAL_DEFAULT "_zipporc"

/* Paths */
typedef enum {
  RC_NONE = 0,  
  RC_INSTALLED_MFT,
  RC_INSTALLED_DSM,
  RC_AVAILABLE_DSM,
  RC_ZIP,
  RC_TAR_GZIP,
  RC_TAR_BZIP2,  
  RC_HTTP_PROXY,
  RC_FTP_PROXY,
  RC_HTTP_MIRROR,
  RC_FTP_MIRROR,
  RC_LOCATION
} rc_resource_t;

/* Lexer & parser variables */
extern FILE *rcfile_yyin;
extern int rcfile_yylineno;

/* Lexer & parser functions */
extern int rcfile_yylex (void);
extern int rcfile_yyparse (void);
extern void rcfile_yyerror (char *s);

/* Functions */
extern int rcfile_init (const char *filename,
			const char *root,
			const char *prefix);

extern int rcfile_parse (void);

extern int rcfile_uninit (void);

int rcfile_add_resource (const rc_resource_t res, const char *path);
extern char **rcfile_get_resources (rc_resource_t res);

#endif	/* __zippo_rcfile_h__ */
