/* $Id: misc.c,v 1.1 2002/07/21 13:21:24 richdawe Exp $ */

/*
 * misc.c - Miscellaneous functions for pakke
 * Copyright (C) 2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"

#include <libpakke/dsm.h>

#include <pakke.h>
#include "misc.h"

/* -------------------
 * - show_dsm_errors -
 * ------------------- */

/* Display all the DSM parsing errors. Only display non-fatal errors
 * in verbose mode. */

int
show_dsm_errors (const char *name, const DSM_ERROR *de, const int verbosity)
{
  const DSM_ERROR *nde;

  for (nde = de; nde != NULL; nde = nde->q_forw) {
    /* If this is non-fatal and we're not in verbose mode, skip this one. */
    if (!nde->fatal && (verbosity != V_VERBOSE))
      continue;

    dsm_perror(name, nde);
  }

  return(1);
}

/* ------------------------
 * - show_dsm_file_errors -
 * ------------------------ */

/* Display all the DSM parsing errors. Only display non-fatal errors
 * in verbose mode. */

int
show_dsm_file_errors (const DSM_FILE_ERROR *dfe, const int verbosity)
{
  const DSM_FILE_ERROR *ndfe;

  for (ndfe = dfe; ndfe != NULL; ndfe = ndfe->q_forw) {
    show_dsm_errors(ndfe->name, ndfe->de, verbosity);
  }

  return(1);
}
