/* Project SWORD
   V2.0

   SubSystem  : Little usefull graphical objects
   File       : Src/Gadgets/ScrolText.CC
   Author     : Eric NICOLAS
   Overview   : TTextScroller object
   UpDate     : Nov 12, 1995

** Copyright (C) 1993,1995 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include "Common/Common.H"
#include "Mecanism/Mecanism.H"
#include "Graphics/Graphics.H"
#include "Drawings/Drawings.H"
#include "Gadgets/Gadgets.H"

// --- TTextScroller  object

short RegTTextScroller;
char *IdentTTextScroller = "TTextScroller";

TTextScroller::TTextScroller() : TScroller()
{ Init();
}

TTextScroller::TTextScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert) :
   TScroller(X,Y,L,H,0,0,_Horiz,_Vert)
{ Init();
}

TTextScroller::TTextScroller(TRect& R, TLift *_Horiz, TLift *_Vert) :
   TScroller(R,0,0,_Horiz,_Vert)
{ Init();
}

void TTextScroller::Init(void)
{ Register=RegTTextScroller;
  Ident=IdentTTextScroller;
  //
  WFont=FontListing->WidthStr("W");
  HFont=FontListing->HeightStr("W");
  SetTextSize(80,50);
}

static char Temp[100];

char *TTextScroller::GetText(int Line)
{ sprintf(Temp,"Essai de chaine n%d - Ca marche ?!",Line+1);
  return Temp;
}

void TTextScroller::SetTextSize(int _NCols, int _NLines)
{ NLines=_NLines;
  NCols=_NCols;
  // Calcule la taille de la fenetre virtuelle en consquence
  WideL=NCols*WFont;
  WideH=NLines*HFont;
  SynchroLifts();
}

void TTextScroller::Draw(TRect& )
{ int   i,i1,i2;
  int   Y1,Y2,L;
  // Calcule les lignes partiellement ou totalement visibles
  i1=DecY/HFont;
  i2=(DecY+Where.H()-1)/HFont+1;
  // Trace le texte
  SetSysColor(GetColor(LightGray));
  FontListing->BackColor(NoSysColor[0]);
  for(i=i1;i<=i2;i++)
    PutStr(-DecX,i*HFont-DecY,GetText(i),FontListing);
  FontListing->BackColor(FBack_NOCOLOR);
  // Trace les fins de ligne
  SetSysColor(GetColor(Black));
  for(i=i1;i<=i2;i++)
  { L=FontListing->WidthStr(GetText(i))-DecX;
    if (L<0) L=0;
    Y1=i*HFont-DecY;
    Y2=(i+1)*HFont-DecY-1;
    if (L<Where.L()) Bar(L,Y1,Where.L()-1,Y2);
  }
}
