/* Project SWORD
   V2.0

   SubSystem : Interface with IntList INTERRUP.LST file
   File      : Include/ToolBox/IntList/IDXView.H
   Author    : Eric NICOLAS
   Overview  : TIndexScroller, TIndexViewer object : Show IntList index part
   UpDate    : Nov 13, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _TOOLBOX_INTLIST_IDXVIEW_H_
#define _TOOLBOX_INTLIST_IDXVIEW_H_

// --- TIndexScroller  object

extern short RegTIndexScroller;
extern char *IdentTIndexScroller;

struct TIndexScroller : TTextScroller
{ protected:
    TBitField *Entries;
  public:
  // Constructors
			 TIndexScroller();
			 TIndexScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert);
          TIndexScroller(TRect& R, TLift *_Horiz, TLift *_Vert);
			 void     Init(void);
  virtual ~TIndexScroller();
  // Gestion du texte
  virtual char    *GetText(int Line);
  virtual boolean  EntryValid(int NEntry);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// --- TCatIndexScroller  object

extern short RegTCatIndexScroller;
extern char *IdentTCatIndexScroller;

struct TCatIndexScroller : TIndexScroller
{ protected:
    char Category;
  public:
  // Constructors
			 TCatIndexScroller();
			 TCatIndexScroller(int X, int Y, int L, int H, TLift *_Horiz, TLift *_Vert, char _Category);
          TCatIndexScroller(TRect& R, TLift *_Horiz, TLift *_Vert, char _Category);
			 void     Init(char _Category);
  // Gestion du texte
  virtual boolean  EntryValid(int NEntry);
  // Objects streams
  virtual TAtom*   Duplicate(void);
};

// Inline functions

inline TAtom* TIndexScroller ::Duplicate(void)
{ return new TIndexScroller();
}

inline TAtom* TCatIndexScroller ::Duplicate(void)
{ return new TCatIndexScroller();
}

#endif // TOOLBOX_INTLIST_IDXVIEW_H_