/* Project SWORD
   V2.0

   SubSystem : Basic objects, General use mecanisms
   File      : Include/Mecanism/Disk.H
   Author    : Eric NICOLAS
   Overview  : Object for accessing disks or other DOS peripherals
   UpDate    : Oct 02, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _MECANISM_DISK_H_
#define _MECANISM_DISK_H

// Constantes pour accs disque via TDisk
#define stCreate     0x0001
#define stOpen       0x0002
#define stTextMode   0x0004
#define stBegining   0
#define stCurrent    1
#define stEnd        2

struct TDisk
{ FILE  *FileHandle;
  int    LastRead;
  TDisk(char *Name, int Acces) { Open(Name,Acces); };
  TDisk() { }
  virtual ~TDisk(void) { Close(); };
  virtual void  Close(void);
  virtual void  Open(char *Name, int Acces);
  virtual void  Read(void *Buffer, int Size);
          void  ReadLn(char *Buffer, int MaxLength);
          void  WriteLn(char *Buffer);
  virtual long  Seek(long Depl, char Mode);
  virtual void  Write(void *Buffer, int Size);
  virtual long  Position(void);
};

#endif // _MECANISM_DISK_H_
