/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/Zone.H
   Author    : Eric NICOLAS
   Overview  : TZone Object = a part of the screen
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_ZONE_H_
#define _GRAPHICS_ZONE_H_

#define wmXOR		GrXOR
#define wmOR		GrOR
#define wmAND		GrAND
#define wmREPLACE 0

struct TZone;

extern short  RegTZone;
extern char  *IdentTZone;
extern TRect  NoClip;
extern TZone *MouseActiveZone;

struct TZone : TObject
{ TRect   Where;
  TPoint  Corner;
  int     SysColor;
  int     SysColorAddition;
  int     DrawStatus;
  int     MouseAspect;
  TRect   Inside;
  // Constructors
          TZone();
          TZone(int X, int Y, int L, int H);
          TZone(TRect& R);
  virtual ~TZone(void);
 	       void     Init(void);
          void     Done(void);
  virtual void     InitAfterInsert(void);
  // Graphics
  virtual void     Draw(TRect& Clip);
  virtual void     Invalidate(TRect& What);
  virtual void     Invalidate(int X1, int Y1, int X2, int Y2);
  virtual void     Invalidate(void);
  virtual void     DoDraw(TRect& Clip);
  virtual void     BecomeActiveZone(void);
  virtual void     LeaveActiveZone(void);
  virtual void     ShowDrawingNow(void);
          void     DrawBegin(void);
	       void     DrawEnd(void);
	       void     MakeGlobal(TPoint Src, TPoint& Dest);
	       void     MakeLocal(TPoint Src, TPoint& Dest);
          void     PutPixel(int X, int Y);
          void     Bar(int X1, int Y1, int X2, int Y2);
	       void     Bar(TRect& R);
	       void     Rectangle(int X1, int Y1, int X2, int Y2);
	       void     LineX(int X1, int Y1, int X2);
	       void     LineY(int X1, int Y1, int Y2);
	       void     Line(int X1, int Y1, int X2, int Y2);
          int      Frame3D(int Down);
          int      Frame3D(int Down, int X1, int Y1, int X2, int Y2);
	       void     PutStr(int X, int Y, char *Text, TFont *Font);
          void     PutSysStr(int X, int Y, char *Text, TFont *Font);
	       void     SetSysColor(int C);
          void     SetWriteMode(int WM);
  virtual int      GetColor(int C);
  virtual void     SetColorGroup(char ColorGroup);
  // Linked list with TZone objects
	      TZone*   First(void);
	      TZone*   Last(void);
	      TZone*   Next(void);
	      TZone*   Previous(void);
	      TZone*   Father(void);
	      TZone*   Son(void);
  // Objects stream
  virtual TAtom*   Duplicate();
  virtual void     Read(TDisk *file);
  virtual void     Write(TDisk *file);
  // Events management
  virtual boolean  MouseMove(TPoint& Where, int Buttons);
  // Others
  virtual void     ShrinkInside(TRect &InsideFather);
  virtual void     Insert(TAtom *A);
  virtual void     DoChangeSize(int dX, int dY);
};

// Inline functions

inline void TZone::Bar(TRect& R)
{ Bar(R.X1(), R.Y1(), R.X2(), R.Y2());
}

inline TZone* TZone::First(void)
{ return (TZone*)(TObject::First());
}

inline TZone* TZone::Last(void)
{ return (TZone*)(TObject::Last());
}

inline TZone* TZone::Next(void)
{ return (TZone*)(TObject::Next());
}

inline TZone* TZone::Previous(void)
{ return (TZone*)(TObject::Previous());
}

inline TZone* TZone::Son(void)
{ return (TZone*)(TObject::Son());
}

inline TZone* TZone::Father(void)
{ return (TZone*)(TObject::Father());
}

inline TAtom* TZone::Duplicate()
{ return new TZone();
}

inline void TZone::Invalidate(int X1, int Y1, int X2, int Y2)
{ Invalidate(TRect(X1,Y1,X2,Y2));
}

inline void TZone::Invalidate()
{ Invalidate(TRect(0,0,Where.L()-1,Where.H()-1));
}

#endif // _GRAPHICS_ZONE_H_
