/* Project SWORD
   V2.0

   SubSystem : Screen graphics management
   File      : Include/Graphics/Rect.H
   Author    : Eric NICOLAS
   Overview  : TRect Object = couple of points (P1,P2)
   UpDate    : Oct 22, 1995

** Copyright (C) 1993,1995 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef _GRAPHICS_RECT_H_
#define _GRAPHICS_RECT_H_

class TRect
{ protected:
    TPoint _P1, _P2;
  public:
    // Constructeurs
    TRect();
    TRect(TPoint& P1, TPoint& P2);
    TRect(TRect& R);
    TRect(int X1, int Y1, int X2, int Y2);
    // Accs aux membres
    int    &X1();
    int    &Y1();
    int    &X2();
    int    &Y2();
    int     L();
    int     H();
    TPoint &P1();
    TPoint &P2();
    // Oprateurs
    TRect  operator+(TRect& R);    // Runion
    TRect  operator+=(TRect& R);
    TRect  operator-(TRect& R);    // Intersection
    TRect  operator-=(TRect& R);
    TRect  operator+(TPoint& P);   // Translation +
    TRect  operator+=(TPoint& P);
    TRect  operator-(TPoint& P);   // Translation -
    TRect  operator-=(TPoint& P);

    boolean Empty();
    boolean operator==(TRect& R);
    // Flux d'objets
    void   Read(TDisk *file);
    void   Write(TDisk *file);
};

inline int &TRect::X1()
{ return _P1.X();
}

inline int &TRect::X2()
{ return _P2.X();
}

inline int &TRect::Y1()
{ return _P1.Y();
}

inline int &TRect::Y2()
{ return _P2.Y();
}

inline int TRect::L()
{ return _P2.X()-_P1.X()+1;
}

inline int TRect::H()
{ return _P2.Y()-_P1.Y()+1;
}

inline TPoint &TRect::P1()
{ return _P1;
}

inline TPoint &TRect::P2()
{ return _P2;
}

#endif // _GRAPHICS_RECT_H_
