#include <X11/XWDFile.h>
#include <stdio.h>

main(argc,argv)
    int  argc;
    char **argv;
{
	XWDFileHeader hdr;
	FILE *inp;
	char *buff,*p;
	int ii,jj;
	int rasterx,rastery;
	int offset;
	int rows,cols;
	int chrx,chry;
	int fg,bg;

	if(argc > 1) {
            if((inp = fopen(argv[1],"r")) == NULL) {
	        fprintf(stderr,"usage: fconv <input file>\n");
	        exit(1);
	    }
	}
	else inp = stdin;
	fread(&hdr,sizeof(hdr),1,inp);
	fprintf(stderr,"bits per pixel: %d\n",hdr.bits_per_pixel);
	fprintf(stderr,"bytes per line: %d\n",hdr.bytes_per_line);
	fprintf(stderr,"pixmap width: %d\n",hdr.pixmap_width);
	fprintf(stderr,"pixmap height: %d\n",hdr.pixmap_height);
	fseek(inp,-(hdr.bytes_per_line * hdr.pixmap_height),2);
	buff = (char *)malloc(hdr.bytes_per_line * hdr.pixmap_height);
	fread(buff,hdr.bytes_per_line,hdr.pixmap_height,inp);
	fclose(inp);
	offset = hdr.bytes_per_line;
	fg = buff[0];
	bg = buff[offset + 1];
	fprintf(stderr,"offset = %d, fg = %d, bg = %d\n",offset,fg,bg);
	p = &buff[offset];
	while(*++p != fg);
	rasterx = ii = p - &buff[offset];
	fprintf(stderr,"width = %d, %d %d\n",ii,buff[offset],buff[offset + ii]);
	p = &buff[1];
	while(*(p += offset) != fg);
	rastery = (p - &buff[1]) / offset;
	chrx = rasterx - 3;
	chry = rastery - 3;
	fprintf(stderr,"rasterx: %d rastery: %d, chrx: %d chry: %d\n",
	    rasterx,rastery,chrx,chry);
	cols = hdr.pixmap_width / rasterx;
	rows = hdr.pixmap_height / rastery;
	if(rows > (128 / cols)) rows = (128 / cols);

	fprintf(stderr,"cols = %d rows = %d\n",cols,rows);
	
	printf("minchar  0\n");
	printf("maxchar  %d\n",(cols * rows) - 1);
	printf("width    %d\n",chrx);
	printf("height   %d\n",chry);
	printf("family   X_misc\n\n");
	for(ii = 0; ii < rows; ii++) {
	    for(jj = 0; jj < cols; jj++) {
	        int x,y,kk,ll;

		x = jj * rasterx + 2;
		y = ii * rastery + 2;
		p = &buff[y * offset + x];
		for(kk = 0; kk < chry; kk++) {
		    for(ll = 0; ll < chrx; ll++) {
			putchar((p[kk * offset + ll] == fg) ? '#' : '.');
		    }
		    putchar('\n');
		}
		putchar('\n');
	    }
	}
		
	exit(0);
}
	


	
