/*----------------------------------------------------------------------
 * 
 *  teechar.c
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  returns a graphic char used to create a complex
 *  box type display
 *
 *  the positions on the box are numbered like this:
 *
 *          0
 *             
 *      3   4   1
 *
 *          2
 *
 *  therefore the characters are shaped like this (0 to 4):
 *
 *      ---          | 
 *       |    --|   ---   |--   -|-
 *
 *  v & h are 0 for single lines, 1 for double lines
 *
 *----------------------------------------------------------------------
 */

#include "curses.h"

teechar(pos, v, h)
int pos, v, h;
{
    static UCHAR teechars[][2][2] = {
        194, 209, 210, 203,
        180, 181, 182, 185,
        193, 207, 208, 202,
        195, 198, 199, 204,
        197, 216, 215, 206
    };
  
    return teechars[pos][v][h] & 0xff;
}

