/*----------------------------------------------------------------------
 *
 *  savescr.c 
 *
 *  copyright (c) 1987,88,89,90 J. Alan Eldridge
 *
 *  save and restore an area of curscr, including cursor position
 *
 *----------------------------------------------------------------------
 */
 
#include "curses.h"

WINDOW *newwin();

WINDOW *
savescr(r,c,y,x)
{
    WINDOW *win;
    
    win = newwin(r,c,y,x);
    if (win) {
        overwrite(curscr, win);
        getyx(curscr, y, x);
        wmove(win, y, x);
    }

    return win;
}


void
restscr(win)
WINDOW *win;
{
    int y, x;
    
    getyx(win, y, x);
    wmove(win, 0, 0);
    wrefresh(win);
    wmove(curscr, y, x);
    mvcur(0, 0, y, x);
}
