/*---------------------------------------------------------------------------+
 |  install.c                                                                |
 |                                                                           |
 | Once-off initialization of wm-FPU-emu                                     |
 |                                                                           |
 | Copyright (C) 1994                                                        |
 |                       W. Metzenthen, 22 Parker St, Ormond, Vic 3163,      |
 |                       Australia.  E-mail   billm@vaxc.cc.monash.edu.au    |
 |                                                                           |
 | See the files "README" and "COPYING" for further copyright and warranty   |
 | information.                                                              |
 |                                                                           |
 +---------------------------------------------------------------------------*/

/* Dummy stuff to get linkage to work */
long __pid = 42, __transfer_buffer = 0, environ = 0;
short _core_select = 0;


/* This code is used to initialise the linkage, etc to the
   emulator. It is called once when the emulator is loaded and
   not used again.
 */
void 
install (void)
{
  asm volatile ("
        pusha
        pushw   %gs
        ");

  asm volatile ("
        movl    %%esi,%0
        movl    %%edi,%1
        ":"=m" (__pid), "=m" (__transfer_buffer));

  asm volatile ("
        movw    $16,%ax
        movw    %ax,%gs
	movl	$_FPU_emu,%ecx   /* The emulator entry address. */
        movl    $56,%eax         /* vector 7 * 8 bpv */
        movw    %cx,%gs:(%eax)
        movw    %cs,%cx
        movw    %cx,%gs:2(%eax)
        movw    $0x8f00,%gs:4(%eax)
        rorl    $16,%ecx
        movw    %cx,%gs:6(%eax)
        ");

  asm volatile ("
        popw    %gs
        popa
        ");
}
