/* This is file FIXSTUB.C */
/*
** Copyright (C) 1993 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
**
** This file is distributed under the terms listed in the document
** "copying.dj", available from DJ Delorie at the address above.
** A copy of "copying.dj" should accompany this file; if not, a copy
** should be available from where this file was obtained.  This file
** may not be distributed without a verbatim copy of "copying.dj".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>

#include "gotypes.h"
#include "stubinfo.h"

word32 offset_of_info = 0;
word32 size_of_info = 0;

StubInfo stub_info = {
  STUB_INFO_MAGIC
};

char *key = stub_info.magic;

void find_info(char *filename)
{  
  FILE *f;
  int ch;
  int key_p = 0;
  long key_max, key_cnt=0;
  unsigned char header[6];

  f = fopen(filename, "rb");
  if (f == 0)
  {
    char buf[100];
    sprintf(buf, "Fatal error in stubedit reading %s", filename);
    perror(buf);
    exit(1);
  }

  fread(header, 6, 1, f);
  key_p += 6;
  key_max = header[4] + header[5]*256 + 1;
  key_max *= 512;

  while ((ch = fgetc(f)) != EOF)
  {
    if (ch == key[key_p])
    {
      key_p++;
      if (key[key_p] == 0)
      {
        fgetc(f); /* the NULL */
        offset_of_info = ftell(f) - 16; /* skip the NULL in the file */
        fread(&size_of_info, 1, 4, f);
        stub_info.struct_length = size_of_info;
        if (size_of_info > sizeof(StubInfo))
          size_of_info = sizeof(StubInfo);
        fseek(f, offset_of_info, 0);
        fread(&stub_info, 1, (int)size_of_info, f);
        fclose(f);
        return;
      }
    }
    else
      key_p = 0;
    key_cnt++;
    if (key_cnt > key_max)
      break;
  }
  fclose(f);
  fprintf(stderr, "Error: I cannot find the stub info structure.  Must be either\n");
  fprintf(stderr, "this is not a stub'd program, or it is older and does not have one.\n");
  exit(1);
}

main(int argc, char **argv)
{
  long info_ofs;
  int stub_f;
  char *stub_fname;
  long size;
  
  if (argc > 1)
    stub_fname = argv[1];
  else
    stub_fname = "stub.exe";

  stub_f = _open(stub_fname, O_RDONLY);
  if (stub_f < 0)
  {
    fprintf(stderr, "Unable to open file %s\n", stub_fname);
    perror("The error was");
    exit(1);
  }

  find_info(stub_fname);

  size = lseek(stub_f, -4L, 2);
  _read(stub_f, &info_ofs, 4);

  if (info_ofs <= 0 || info_ofs > size || info_ofs != offset_of_info)
  {
    unsigned short header[2];
    int stub_f = _open(stub_fname, O_WRONLY);
    if (stub_f < 0)
    {
      fprintf(stderr, "Error: cannot write to %s\n", stub_fname);
      perror("The error was");
      exit(1);
    }
    size = lseek(stub_f, 0L, 2) + 4;
    size = (size+511)&~511;
    lseek(stub_f, size-4, 0);
    _write(stub_f, &offset_of_info, 4);
    header[0] = size & 511;
    header[1] = (size + 511)/512;
    lseek(stub_f, 2L, 0);
    _write(stub_f, header, 4);
    _close(stub_f);
  }

  _close(stub_f);

  return 0;
}
