#include "emu.h"
#include "rmov.h"
#include "compare.h"

void emu_54()
{
  if (modrm > 0277)
  {
    // fucom st(i)
    if (empty())
      return;
    if (empty(modrm&7))
    {
      setcc(SW_C3|SW_C2|SW_C0);
      return;
    }
    int c = compare(st(), st(modrm&7));
    int f;
    if (c & COMP_SNAN)
    {
      exception(EX_I);
      f = SW_C3 | SW_C2 | SW_C0;
    }
    else
      switch (c)
      {
        case COMP_A_LT_B:
          f = SW_C0;
          break;
        case COMP_A_EQ_B:
          f = SW_C3;
          break;
        case COMP_A_GT_B:
          f = 0;
          break;
        case COMP_NOCOMP:
          f = SW_C3 | SW_C2 | SW_C0;
          break;
      }
    setcc(f);
    
  }
  else
  {
    // frestor
    void *addr = get_modrm();
    int i, tag_word;

    control_word = *(int *)(addr+0) & 0xffff;
    status_word = *(int *)(addr+4) & 0xffff;
    tag_word = *(int *)(addr+8) & 0xffff;
    top = (status_word / SW_TOPS) & 3;
    for (i=0; i<8; i++)
    {
      r_mov((long double *)(addr + 0x1c + 10), st(i));
      st(i).tag = (tag_word >> (((i+top)&7)*2)) & 3;
    }
  }
}
