; FontLoad.asm
; Copyright(C) 1994/1995 by The Wonderful Team. Code: >-$wz->

;**

; last mod:   8-27-95 11:11am 
; - fixes:
;    80h instead of 80 filename buffer
;    EOL at 1st char less of equal space
;    file closed right before read, if there was an error
;     it wasn't closed!
; - improvs:
;    Font size check and textmode change IF different mode found
;    Check 4 read error

;**

include Asm.inc

.286
.model small
.stack 100h
.data

logo db "Ŀ",CR,LF
     db "             .oO( FontLoad ! FREEWARE Dos Font Loader )Oo.             ",CR,LF
     db "   [   (C) 1995 by The Wonderful Team.   Version 1.1   ]   ",CR,LF
     db "",CR,LF
     db EOM

nopar db                                                    CR,LF
      db "Syntax:  FontLoad fontfile.ext"                  ,CR,LF
      db EOM

notfound db                                                    CR,LF
         db "File Not Found !!"                               ,CR,LF
         db EOM
ErrorRead db                                                    CR,LF
          db "File Read Error !"                               ,CR,LF
          db EOM

Errorsize db                                                    CR,LF
          db "Font file size mismatch; Must be at least:",CR,LF
          db "4096 bytes for 8x16 charset",CR,LF
          db "2048 bytes for 8x8  charset",CR,LF
          db EOM


found db                                                    CR,LF
      db "Font Loaded"                                     ,CR,LF
      db EOM

handle dw 1

buffer db 4098 DUP(0)

filename db 80h DUP(0) ; not 80 decimal!

;**
;  Code start
;**

.CODE
.STARTUP
        @INIEXE
        @SAY LOGO

;**
;  Commandline Parser
;**

        cmp     byte ptr es:0080h, 00
        jne     @@getname

        @SAY    nopar
        jmp     @@end

@@getname:
        mov     di, 0082h       ; (ES:DI) -> (DS:SI)
        lea     si, filename

@@loopname:
        mov     al, byte ptr ES:[DI]
        cmp     al, 21h         ; "!" and up valid , space and below = EOL
        jb      @@openfile      ; there's no need to go further

@@getch:
        mov     byte ptr DS:[SI], al
        inc     di
        inc     si
        jmp     @@loopname

;**
;  Process File
;**

@@openfile:
        lea     dx, filename
        @DOS    3Dh             ; open file

        jnc     @@readbuf       ; if open read buffer
        @SAY    notfound
        jmp     @@end

@@readbuf:
        mov     handle, ax      ; save handle

        lea     dx, buffer
        mov     cx, 4098        ; try to read 2 bytes more than needed
        mov     bx, handle
        @DOS    3Fh
        push    ax              ; bytes read
        pushf                   ; CF->ERROR saved
        mov     bx, handle      ; Close file
        @DOS    3Eh
        popf
        pop     ax
        jnc     @@chkchars
        @SAY    ErrorRead
        jmp     @@end

@@chkchars:
        cmp     ax,0800h        ; 2048 bytes: font 8x8 (80x50)
        jne     @@chk25
        Push    ax              ; bytes read
        ;---------------
        call    reqchar
        ;---------------
        cmp     DL,49           ; already in 80x50?
        je      @@setchars

        mov     ax,1112h        ; 80x50 w/o clearing
        xor     bl,bl
        mov     dx,002bh
        int     10h
        jmp     @@setchars

@@chk25:
        cmp     ax,1000h        ; 4096 bytes: font 8x16 (80x25)
        je      @@set25
        @SAY    Errorsize
        jmp     @@end

@@set25:
        Push    ax              ; bytes read
        ;---------------
        call    reqchar
        ;---------------
        cmp     DL,24           ; already in 80x25?
        je      @@setchars
        ;MOV     ax,83h         ; 80x25 w/o clearing (have 2 B tested yet!)
        ;INT     10h            ; But cursor will be repositioned, so...
        MOV     ax,03h          ; set 80x25
        INT     10h
        @SAY    LOGO

@@setchars:
        mov     bx, ds          ; Set new CharSet
        mov     es, bx
        lea     ax, buffer
        mov     bp, ax          ; ES:BP Buffer
        pop     bx              ; bytes read; upper byte (BH) -> bytes/char
        mov     cx, 256         ; 256 chars
        xor     dx, dx
        @BIOS   11h,00h         ; font change

        @SAY    found

@@end:
        @DOS    EXIT            ; have fun with a new font!

reqchar proc    near
        push    es
        push    bp
        mov     ax,1130h        ; request font information
        mov     bx,0400         ; dummy... get 8x8 chars buffer in es:bp
        int     10h             ; returns DL -> maxrow()
        pop     bp              ;         CX -> bytes/Char (8 or 16)
        pop     es
        ret
endp
END
