/***************************
 * winent.c v. 2.2 patch B, ANSI C
 *
 * Replaces high characters in flat text files
 * with their HTML entity names (mnemonic)
 * and does a few more tricks
 *
 * Joao Magalhaes, 1998, jcm@mail.EUnet.pt
 *
 *	NOTE: This code is my intelectual property,
 *	that is, it is NOT public domain.
 *	If you intend to modify it, ok, but you are
 *	requested to make the executable
 * 	state you did it.
 */

#include <stdio.h>
#include <process.h>
#include <ctype.h>
#include <string.h>
#include <time.h>


void WriteHelp(void)
   {
   puts("USE: WINENT [-flags] [title] < infile.txt [ > outfile.ht]");
   puts("\tFlags are to be together in a single string preceded by a '-':");
   puts("\tAll are disabled by default.");
   puts("\t\tT : no HTML tags at all");
   puts("\t\te : no character replacement by HTML 3.2 entities");
   puts("\t\td : no date / time stamp");
   puts("\t\th : no HEAD section");
   puts("\t\ts : no HTML sections \(HTML, HEAD, BODY\)");
   puts("\t\tt : insert the title as a H3 document header");
   puts("\t\ti : paragraphs start with indents");
   puts("\t\t? : help. Displays this screen.");
   puts("\tTitle: a string enclosed in quotes, e.g. \"This is a title\".");
   puts("\tExample:");
   puts("\tWINENT -die \"Why Mary had a lamb\" < lamb.txt > lamb.htm");
   printf("WinEnt v. 2.2 compiled %s %s\n", __DATE__, __TIME__);
   exit(1);
   }

char * GetTime(char * TimeString)
   {
   time_t Seconds;
   struct tm *T;

   time(&Seconds);
   T= localtime(&Seconds);

   sprintf(TimeString, "%02d-%02d-%02d %02d:%02d.%02d",
	T->tm_year,
	T->tm_mon+1,
	T->tm_mday,
	T->tm_hour,
	T->tm_min,
	T->tm_sec);

   return TimeString;
   }


void WriteAHeader(int Bypass, char * T)
   {
   char S[80];
   puts("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
   puts("\n<HTML>");
   if (Bypass)
      {
      puts("\n<HEAD>");
      puts("<TITLE>");
      if (*T) printf("%s\n", T);
      else puts("*** Untitled Raw Text With HTML Entities by WinEnt ***");
      puts("</TITLE>");
      puts("</HEAD>");
      }
   puts("\n<BODY>\n");

   puts("<!-- Conversion from Windows \(ISO-8859-1 Latin-1\)\
 Character Set by -->");
   puts("<!-- WinEnt by Joao Magalhaes Oct. 1998 jcm@mail.EUnet.pt -->");
   puts("<!-- User supported freeware with ANSI C source -->");
   puts("<!-- USE: winent [flags] [title] <infilename [> outfilename] -->");
   printf("<!-- Version 2.2, compiled %s %s -->\n", __DATE__, __TIME__);
   printf("<!-- Raw file converted by WinEnt: %s -->\n", GetTime(S));
   }



void WinEntities(unsigned char C)
   {
   static const unsigned char Table [97][10]=
	{
	{"&nbsp;"},
	{"&iexcl;"}, {"&cent;"},   {"&pound;"}, {"&curren;"}, {"&yen;"},
	{"&brvbar;"},{"&sect;"},   {"&uml;"},   {"&copy;"},   {"&ordf;"},
	{"&laquo;"}, {"&not;"},    {"&shy;"},   {"&reg;"},    {"&macr;"},
	{"&deg;"},   {"&plusmn;"}, {"&sup2;"},  {"&sup3;"},   {"&acute;"},
	{"&micro;"}, {"&para;"},   {"&middot;"},{"&cedil;"},  {"&supl;"},
	{"&ordm;"},  {"&raquo;"},  {"&frac14;"},{"&frac12;"}, {"&frac34;"},
	{"&iquest;"},
/***************************/
	{"&Agrave;"}, {"&Aacute;"},{"&Acirc;"},  {"&Atilde;"},
	{"&Auml;"},  {"&Aring;"},  {"&AElig;"}, {"&Ccedil;"}, {"&Egrave;"},
	{"&Eacute;"},{"&Ecirc;"},  {"&Euml;"},  {"&Igrave;"}, {"&Iacute;"},
	{"&Icirc;"}, {"&Iuml;"},   {"&ETH;"},   {"&Ntilde;"}, {"&Ograve;"},
	{"&Oacute;"},{"&Ocirc;"},  {"&Otilde;"},{"&Ouml;"},   {"&#215;"},
	{"&Oslash;"},{"&Ugrave;"}, {"&Uacute;"},{"&Ucirc;"},  {"&Uuml;"},
	{"&Yacute;"},{"&THORN;"},  {"&szlig;"}, {"&agrave;"}, {"&aacute;"},
	{"&acirc;"}, {"&atilde;"}, {"&auml;"},  {"&aring;"},  {"&aelig;"},
	{"&ccedil;"},{"&egrave;"}, {"&eacute;"},{"&ecirc;"},  {"&euml;"},
	{"&igrave;"},{"&iacute;"}, {"&icirc;"}, {"&iuml;"},   {"&eth;"},
	{"&ntilde;"},{"&ograve;"}, {"&oacute;"},{"&ocirc;"},  {"&otilde;"},
	{"&ouml;"},  {"&#247;"},   {"&oslash;"},{"&ugrave;"}, {"&uacute;"},
	{"&ucirc;"}, {"&uuml;"},   {"&yacute;"},{"&thorn;"},  {"&yuml;"},
	{0x00}
	};

/* 215 and 247 are not defined */

   if (C<128)
      {
      switch (C)
	 {
	 case '\"'  : printf("&#034;");  break; /* former 'quot' */
	 case '&'   : printf("&amp;");  break;
	 case '<'   : printf("&lt;");   break;
	 case '>'   : printf("&gt;");   break;
	 default:
	    putchar(C);
	 }
      }
   else
   /*
      if (C<192) printf("[!UNSUPPORTED: %d %c]", (int) C, C);
      else printf("%s", Table[C-192]);
   */
/* If you uncomment out entities, use the following lines instead
   of the previous 2 lines:
 */
      if (C<160) printf("[!UNSUPPORTED: %d %c]", (int) C, C);
      else printf("%s", Table[C-160]);
   }


void WriteTime(void)
   {
   char S[80];
   printf("\n<P>\n<TT>\nRaw file generated by WinEnt: %s\n</TT>\n</P>\n",
	GetTime(S));
   }


void WriteAEnd(void)
   {
   puts("\n</BODY>");
   puts("\n</HTML>");
   }


int main (int argc, char ** argv)
   {
   int C, Prev, PrevPrev;
   int Chars;
   int NoTags, NoEnts, NoTime, NoHead,
	NoH3Head, NoIndents, NoSections;
   char Title[80];

   NoTags=NoEnts=NoTime=NoHead=NoSections=C=Chars=0;
   NoIndents=NoH3Head=1;
   PrevPrev=Prev='\n';
   for (C=0; C < 80; C++) Title[C]=0x00;
   C=0;

  if (argc > 1)
   {
   if (*argv[1] == '-')
      {
      argv[1]++;
      while (*argv[1])
	 {
	 switch (*argv[1])
	    {
	    case 'T' : NoTags = 1; break;
	    case 'e' : NoEnts = 1; break;
	    case 'd' : NoTime = 1; break;
	    case 'h' : NoHead = 1; break;
	    case 't' : NoH3Head = 0; break;
	    case 'i' : NoIndents = 0; break;
	    case 's' : NoSections=1; break;
	    case '?' : WriteHelp(); break;
	    default  : WriteHelp(); break;
	    }
	 argv[1]++;
	 }
      if (*argv[2]) strcpy(Title, argv[2]);
      }
   else if (*argv[1]) strcpy(Title, argv[1]);
   }

   if ((!NoTags) && (!NoSections))
	WriteAHeader(!NoHead, Title);

   if ((NoH3Head) || (NoTags));
   else printf("\n<H3>%s</H3>\n", Title);

   while ((C=getchar()) != EOF)
      {
      if (C < 0x09)
	 {
	 printf("[!CONTROL: %x]", C);
	 continue;
	 }

      if ((PrevPrev=='\n') && (Prev=='\n') && (C!='\n'))
	 {
	 if (! NoTags)
		if (NoIndents) puts("\n<P>");
		else
		   printf("\n<BR>&#160;&#160;&#160;&#160;&#160;");
	 PrevPrev=Prev;
	 Prev=C;
	 if (NoIndents) Chars=0; else Chars+=35;
	 }

      if ((PrevPrev!='\n') && (Prev=='\n') && (C=='\n'))
	 {
	 if (! NoTags)
		if (NoIndents) puts("\n</P>");
		else putchar('\n');
	 PrevPrev=Prev;
	 Prev=C;
	 continue;
	 }

      if (isspace(C)) putchar(' ');
      else
	if (NoEnts) putchar(C);
	else WinEntities((unsigned char) C);
      Chars++;

      if ( (unsigned char) C > 127 && ! NoEnts) Chars+=6;
      if ((Chars > 40) && (C==0x20))
	 {
	 putchar('\n');
	 Chars=0;
	 }
      PrevPrev=Prev;
      Prev=C;

      }

   if (! ( NoTags || NoTime)) WriteTime();
   if ((! NoTags) && (! NoSections)) WriteAEnd();

   return 0;
   }
